/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Cache;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Fov;
import cds.aladin.FrameHeaderFits;
import cds.aladin.FrameHipsProperties;
import cds.aladin.HealpixAllsky;
import cds.aladin.HealpixAllskyPol;
import cds.aladin.HealpixKey;
import cds.aladin.HealpixKeyPol;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanBGRgb;
import cds.aladin.PlanHealpix;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.Server;
import cds.aladin.TreeObjDir;
import cds.aladin.ViewMemoItem;
import cds.aladin.ViewSimple;
import cds.aladin.stc.STCCircle;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import cds.astro.Coo;
import cds.fits.HeaderFits;
import cds.moc.Healpix;
import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.SMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class PlanBG
extends PlanImage {
    static final boolean NOALLSKY = false;
    static final int DRAWPIXEL = 0;
    static final int DRAWPOLARISATION = 1;
    protected boolean segmentIAUConv;
    private float segmentLenFactor;
    private int segmentThickness;
    private float segmentDensityFactor;
    private Color oc;
    protected int drawMode;
    static final String CACHE = "Background";
    static long MAXCACHE = 0x400000L;
    protected static final int LIVETIME = 3000;
    protected MyProperties prop;
    protected String gluTag;
    protected String survey;
    protected String urlSuffix;
    protected String version;
    protected String url;
    protected int minOrder;
    protected int maxOrder;
    protected Hashtable<String, HealpixKey> pixList;
    protected HealpixLoader loader;
    protected boolean hasDrawnSomething;
    protected boolean allWaitingKeysDrawn;
    protected boolean useCache;
    protected boolean cube;
    protected boolean color;
    protected boolean colorPNG;
    protected boolean colorUnknown;
    public boolean fitsGzipped;
    public boolean truePixels;
    public boolean inFits;
    public boolean inJPEG;
    public boolean inPNG;
    protected boolean hasMoc;
    protected boolean hasHpxFinder;
    protected int frameOrigin;
    protected int frameDrawing;
    protected boolean local;
    protected boolean live;
    protected boolean loadMocNow;
    protected String pixelRange;
    protected String pixelCut;
    protected int transferFct4Fits;
    protected int transferFct4Preview;
    protected boolean flagNoTarget;
    private boolean flagWaitAllSky;
    protected boolean hasAllSky;
    protected int tileOrder;
    protected int[] RGBCONTROL;
    protected int[] RGBControl;
    protected boolean specificProj;
    static volatile long cacheSize = -1L;
    private static Object cacheLock = new Object();
    private int polaScaleFactor;
    protected long memSize;
    private boolean testMoc;
    private boolean testHpxFinder;
    protected SMoc moc;
    private static final String[] SKYFRAME = new String[]{"g", "gal", "galactic", "e", "ecl", "ecliptic", "c", "equ", "equatorial"};
    private static final int MAXCHECKSITE = 3;
    private int nbCheckSite;
    private FrameHipsProperties frameHipsProperties;
    private boolean flagClearBuf;
    private PlanBGRgb planBgRgb;
    protected boolean flagRecut;
    protected double flagRecutRadius;
    protected Coord flagRecutCoo;
    private String cacheName;
    private String dirCache;
    private boolean flagCache;
    protected int nbReady;
    private static Thread scanCache = null;
    private static long NBFILE = 0L;
    protected int nbFlush;
    private long lastGc;
    private long lastMemP;
    private long lastMemI;
    private static int MEMREQUIREDFORGC = 0x2800000;
    private boolean memCpt;
    private boolean firstSubtil;
    private static final long[] ALLSKY = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L};
    protected static String CURRENTMODE = "";
    protected double[] RES;
    private int allSkyOrder;
    public static final int DIRSIZE = 10000;
    protected int[] xy2hpx;
    protected int[] hpx2xy;
    private long lastTouch;
    protected long lastIz;
    protected int lastMaxOrder;
    private int oLosangeOrder;
    private boolean hasMoreDetails;
    private long[] children;
    boolean first1;
    private int lastHistID;
    private double[] histRed;
    private double[] histGreen;
    private double[] histBlue;
    protected byte[] red;
    protected byte[] green;
    protected byte[] blue;
    private Timer timer;
    boolean readyAfterDraw;
    boolean readyDone;
    protected int priority;
    protected static int nDraw1 = 0;
    protected static int nOut1 = 0;
    static final int DRAWFASTMS = 100;
    private boolean computeDrawFast;
    private boolean lastMustDrawFast;
    private static final int MAXSTAT = 5;
    private int nStat;
    private long[] statTimeDisplayArray;
    private boolean first;
    private boolean fading;
    private float op;
    static final int M = 2;
    private long timerLastDrawBG;
    private int nbgzip;
    private long timegzip;
    private int nbnogzip;
    private long timenogzip;
    private int gzipMode;
    private static int THREADID = 0;
    private boolean oLoading;
    private static final int MAXTIMETOBELOADFROMNET = 1000;
    protected long cumulTimeLoadNet;
    protected long cumulTimeLoadCache;
    protected long cumulTimeWriteCache;
    protected long cumulTimeDraw;
    protected long cumulTimeStream;
    protected long cumulTimeJPEG;
    protected long cumulTimePixel;
    protected int nbLoadNet;
    protected int nbLoadCache;
    protected int nbWriteCache;
    protected int nbImgDraw;
    protected long nByteReadNet;
    protected long nByteReadCache;
    protected long nByteWriteCache;
    protected int nbImgCreated;
    protected int nbImgInBuf;
    protected int nbCreated;
    protected int nbAborted;
    protected int nbFree;

    protected void setDrawMode(int mode) {
        this.drawMode = mode;
        if (this.drawMode == 1) {
            if ((double)this.opacityLevel < 0.1) {
                this.setOpacityLevel(1.0f);
            }
            if (this.oc == null) {
                this.oc = this.c = Couleur.getNextDefault(this.aladin.calque);
            } else {
                this.c = this.oc;
            }
        } else {
            this.c = Color.black;
        }
        this.type = mode == 1 ? 17 : 16;
    }

    protected PlanBG(Aladin aladin) {
        super(aladin);
        this.segmentIAUConv = false;
        this.segmentLenFactor = 1.0f;
        this.segmentThickness = 1;
        this.segmentDensityFactor = 1.0f;
        this.oc = null;
        this.drawMode = 0;
        this.prop = null;
        this.gluTag = null;
        this.urlSuffix = null;
        this.version = "";
        this.minOrder = 3;
        this.maxOrder = 14;
        this.hasDrawnSomething = false;
        this.allWaitingKeysDrawn = false;
        this.useCache = true;
        this.cube = false;
        this.color = false;
        this.colorPNG = false;
        this.colorUnknown = false;
        this.fitsGzipped = false;
        this.truePixels = false;
        this.inFits = false;
        this.inJPEG = false;
        this.inPNG = false;
        this.hasMoc = false;
        this.hasHpxFinder = false;
        this.frameOrigin = 0;
        this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
        this.live = false;
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.transferFct4Fits = 3;
        this.transferFct4Preview = 3;
        this.flagNoTarget = false;
        this.hasAllSky = true;
        this.tileOrder = -1;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.specificProj = false;
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.testHpxFinder = false;
        this.nbCheckSite = 0;
        this.frameHipsProperties = null;
        this.flagClearBuf = false;
        this.planBgRgb = null;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastMaxOrder = 3;
        this.oLosangeOrder = -1;
        this.hasMoreDetails = true;
        this.children = null;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.op = 0.0f;
        this.timerLastDrawBG = 0L;
        this.nbgzip = 0;
        this.timegzip = 0L;
        this.nbnogzip = 0;
        this.timenogzip = 0L;
        this.gzipMode = 0;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.initCache();
        this.suiteSpecific();
        this.type = 16;
    }

    protected PlanBG(Aladin aladin, TreeObjDir to, String label, Coord c, double radius, String startingTaskId) {
        super(aladin);
        this.segmentIAUConv = false;
        this.segmentLenFactor = 1.0f;
        this.segmentThickness = 1;
        this.segmentDensityFactor = 1.0f;
        this.oc = null;
        this.drawMode = 0;
        this.prop = null;
        this.gluTag = null;
        this.urlSuffix = null;
        this.version = "";
        this.minOrder = 3;
        this.maxOrder = 14;
        this.hasDrawnSomething = false;
        this.allWaitingKeysDrawn = false;
        this.useCache = true;
        this.cube = false;
        this.color = false;
        this.colorPNG = false;
        this.colorUnknown = false;
        this.fitsGzipped = false;
        this.truePixels = false;
        this.inFits = false;
        this.inJPEG = false;
        this.inPNG = false;
        this.hasMoc = false;
        this.hasHpxFinder = false;
        this.frameOrigin = 0;
        this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
        this.live = false;
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.transferFct4Fits = 3;
        this.transferFct4Preview = 3;
        this.flagNoTarget = false;
        this.hasAllSky = true;
        this.tileOrder = -1;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.specificProj = false;
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.testHpxFinder = false;
        this.nbCheckSite = 0;
        this.frameHipsProperties = null;
        this.flagClearBuf = false;
        this.planBgRgb = null;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastMaxOrder = 3;
        this.oLosangeOrder = -1;
        this.hasMoreDetails = true;
        this.children = null;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.op = 0.0f;
        this.timerLastDrawBG = 0L;
        this.nbgzip = 0;
        this.timegzip = 0L;
        this.nbnogzip = 0;
        this.timenogzip = 0L;
        this.gzipMode = 0;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.startingTaskId = startingTaskId;
        this.initCache();
        this.gluTag = to.getID();
        this.id = to.internalId;
        this.url = to.getUrl();
        this.survey = to.label;
        this.version = to.version;
        this.minOrder = to.minOrder;
        this.maxOrder = to.maxOrder;
        this.useCache = to.useCache();
        this.local = to.local;
        this.loadMocNow = to.loadMocNow();
        this.frameOrigin = to.frame;
        this.description = to.description;
        this.verboseDescr = to.verboseDescr;
        this.ack = to.ack;
        this.copyright = to.copyright;
        this.copyrightUrl = to.copyrightUrl;
        this.co = c;
        this.coRadius = radius;
        if (label != null && label.trim().length() > 0) {
            this.setLabel(label);
        }
        this.setSpecificParams(to);
        Aladin.trace(3, "HiPS creation: " + to.toString1() + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected void initTileParam(int width, int height, int bitpix, byte[] pixelsOrigin, byte[] pixels) {
        if (this.color) {
            return;
        }
        this.pixelsOrigin = pixelsOrigin;
        this.pixels = pixels;
        this.bitpix = bitpix;
        this.npix = Math.abs(bitpix) / 8;
        this.naxis1 = this.width = width;
        this.naxis2 = this.height = height;
        if (this.hasRecutListener()) {
            this.getRecutListener().initTileParam(width, height);
        }
    }

    private void resetCache() {
        String dirname = this.getCacheDir() + cds.tools.Util.FS + this.getCacheName();
        File f = new File(dirname);
        for (int i = 1; i < 10 && !f.renameTo(new File(this.getCacheDir() + cds.tools.Util.FS + this.getCacheName() + "." + i + ".old")); ++i) {
        }
        new File(this.getCacheDir() + cds.tools.Util.FS + this.getCacheName()).mkdir();
        Aladin.trace(3, "HEALPix local cache for " + this.getCacheName() + " is out of date => renamed => will be removed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyProperties loadPropertieFile() {
        if (this.prop != null) {
            return this.prop;
        }
        String dateRef = null;
        boolean local = !this.url.startsWith("http:") && !this.url.startsWith("https:") && !this.url.startsWith("ftp:");
        try {
            InputStream in = null;
            if (local) {
                in = new FileInputStream(new File(this.url + cds.tools.Util.FS + "properties"));
            } else {
                File f;
                block25: {
                    String cacheFile = this.getCacheDir() + cds.tools.Util.FS + this.getCacheName() + cds.tools.Util.FS + "properties";
                    f = new File(cacheFile);
                    String urlFile = this.url + "/" + "properties";
                    if (this.isDynHiPS()) {
                        urlFile = urlFile + "?" + this.urlSuffix;
                        System.out.println("Scanning for " + urlFile);
                    }
                    HttpURLConnection conn = (HttpURLConnection)new URL(urlFile).openConnection();
                    if (this.useCache && f.exists()) {
                        conn.setIfModifiedSince(f.lastModified());
                        this.prop = new MyProperties();
                        InputStreamReader in1 = new InputStreamReader(new FileInputStream(f));
                        this.prop.load(in1, true, false);
                        in1.close();
                        dateRef = this.prop.getProperty("hips_release_date");
                        if (dateRef == null) {
                            dateRef = this.prop.getProperty("processingDate", "");
                        }
                    }
                    try (MyInputStream dis = null;){
                        in = conn.getInputStream();
                        int code = conn.getResponseCode();
                        if (code == 304) {
                            throw new Exception();
                        }
                        if (!this.useCache) break block25;
                        dis = new MyInputStream(in);
                        byte[] buf = dis.readFully();
                        dis.close();
                        this.prop = new MyProperties();
                        InputStreamReader in1 = new InputStreamReader(new ByteArrayInputStream(buf));
                        this.prop.load(in1, true, false);
                        in1.close();
                        String dateRef1 = this.prop.getProperty("hips_release_date");
                        if (dateRef1 == null) {
                            dateRef1 = this.prop.getProperty("processingDate", "");
                        }
                        if (dateRef1.equals(dateRef)) {
                            throw new Exception();
                        }
                        try (RandomAccessFile fcache = null;){
                            this.resetCache();
                            f = new File(cacheFile);
                            fcache = new RandomAccessFile(f, "rw");
                            fcache.write(buf);
                        }
                    }
                }
                if (f.exists()) {
                    in = new FileInputStream(f);
                }
            }
            if (in == null) {
                throw new Exception();
            }
            this.prop = new MyProperties();
            this.prop.load(new InputStreamReader(in), true, false);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            this.prop = null;
        }
        return this.prop;
    }

    static final void touch(File f) {
        f.setLastModified(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scanMetadata() {
        MyInputStream in = null;
        try {
            in = cds.tools.Util.openAnyStream(this.url + cds.tools.Util.FS + "metadata.txt");
            byte[] res = in.readFully();
            HeaderFits h = new HeaderFits();
            h.readFreeHeader(new String(res));
            this.headerFits = new FrameHeaderFits(h);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static String getHiPSID(MyProperties prop) {
        String s = prop.getProperty("creator_did");
        if (s == null) {
            s = prop.getProperty("publisher_did");
        }
        if (s == null && (s = prop.getProperty("obs_id")) != null) {
            String s1 = prop.getProperty("creator_id");
            if (s1 == null) {
                s1 = prop.getProperty("publisher_id");
            }
            s = s1 != null ? s1 + "?" + s : null;
        }
        if (s == null) {
            s = prop.getProperty("id");
        }
        if (s.startsWith("ivo://")) {
            s = s.substring(6);
        }
        return s;
    }

    protected boolean checkSite() {
        boolean lookForFaster;
        boolean bl = lookForFaster = !this.aladin.glu.checkSiteHistory(this.gluTag);
        if (!lookForFaster) {
            try {
                URL u = this.aladin.glu.getURL(this.gluTag, "", false, true, 1);
                if (u != null) {
                    this.url = u.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lookForFaster;
    }

    protected boolean scanProperties() {
        boolean rep = true;
        boolean alternative = true;
        boolean lookForFaster = false;
        if (!(this.local || this.id != null && this.id.startsWith("DIRECT/"))) {
            URL u;
            lookForFaster = this.checkSite();
            URL uRL = u = this.gluTag == null ? null : this.aladin.glu.getURL(this.gluTag, "", false, false, 2);
            if (u == null) {
                alternative = false;
            }
        }
        if (!this.scanProperties1() && alternative) {
            Aladin.trace(3, "HiPS server unreachable [" + this.url + "] ! Trying another...");
            this.checkSite(false);
            rep = this.scanProperties1();
        } else if (alternative && lookForFaster) {
            Aladin.trace(3, "HiPS server OK [" + this.url + "], looking for a faster...");
            new Thread(){

                @Override
                public void run() {
                    PlanBG.this.checkSite(false);
                }
            }.start();
        }
        return rep;
    }

    private boolean scanProperties1() {
        try {
            int i2;
            String s;
            MyProperties prop = this.loadPropertieFile();
            if (prop == null) {
                throw new Exception();
            }
            Aladin.trace(4, "PlanBG.setSpecificParams() found a \"properties\" file");
            int frame = -1;
            String strFrame = prop.getProperty("hips_frame", "X");
            if (strFrame.equals("equatorial") || this.isPlanet(strFrame)) {
                frame = 0;
            } else if (strFrame.equals("galactic")) {
                frame = 3;
            } else if (strFrame.equals("ecliptic")) {
                frame = 2;
            }
            if (this.isPlanet(strFrame)) {
                this.setBody(strFrame.trim().toLowerCase());
            } else {
                this.setBody("sky");
            }
            if (strFrame.equals("X")) {
                strFrame = prop.getProperty("coordsys", "X");
                char c1 = strFrame.charAt(0);
                if (c1 == 'C' || c1 == 'Q') {
                    frame = 0;
                } else if (c1 == 'E') {
                    frame = 2;
                } else if (c1 == 'G') {
                    frame = 3;
                }
            }
            if (frame != -1 && frame != this.frameOrigin) {
                Aladin.trace(1, "Coordinate frame found in properties file (" + Localisation.getFrameName(frame) + ") differs from the remote information (" + Localisation.getFrameName(this.frameOrigin) + ") => assume " + Localisation.getFrameName(frame));
                this.frameOrigin = frame;
            }
            if ((s = prop.getProperty("obs_title")) == null) {
                s = prop.getProperty("description");
            }
            if (s != null) {
                this.description = s;
            }
            if ((s = prop.getProperty("obs_description")) == null) {
                s = prop.getProperty("verboseDescription");
            }
            if (s != null) {
                this.verboseDescr = s;
            }
            if ((s = prop.getProperty("obs_ack")) == null) {
                s = prop.getProperty("acknowledgement");
            }
            if (s != null) {
                this.ack = s;
            }
            if ((s = prop.getProperty("obs_copyright")) == null) {
                s = prop.getProperty("copyright");
            }
            if (s != null) {
                this.copyright = s;
            }
            if ((s = prop.getProperty("obs_copyright_url")) == null) {
                s = prop.getProperty("copyrightUrl");
            }
            if (s != null) {
                this.copyrightUrl = s;
            }
            if ((s = prop.getProperty("hips_data_range")) == null) {
                s = prop.getProperty("pixelRange");
            }
            if (s != null) {
                this.pixelRange = s;
            }
            if ((s = prop.getProperty("hips_pixel_cut")) == null) {
                s = prop.getProperty("pixelCut");
            }
            if (s != null) {
                this.pixelCut = s;
            }
            if ((s = prop.getProperty("hips_pixel_function")) != null && (i2 = cds.tools.Util.indexInArrayOf(s, TRANSFERTFCT, true)) >= 0) {
                this.transferFct4Fits = i2;
            }
            this.id = PlanBG.getHiPSID(prop);
            s = prop.getProperty("hips_order");
            if (s == null) {
                s = prop.getProperty("maxOrder");
            }
            if (s != null) {
                try {
                    this.maxOrder = Integer.parseInt(s);
                }
                catch (Exception i2) {
                    // empty catch block
                }
            }
            if ((s = prop.getProperty("hips_order_min")) == null) {
                s = prop.getProperty("minOrder");
            }
            if (s != null) {
                try {
                    this.minOrder = Integer.parseInt(s);
                }
                catch (Exception i2) {
                    // empty catch block
                }
            }
            if ((s = prop.getProperty("hips_tile_width")) != null) {
                try {
                    int w = Integer.parseInt(s);
                    this.tileOrder = (int)CDSHealpix.log2(w);
                }
                catch (Exception exception) {}
            } else {
                s = prop.getProperty("tileOrder");
                if (s != null) {
                    try {
                        this.tileOrder = Integer.parseInt(s);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if ((s = prop.getProperty("dataproduct_subtype")) != null && s.indexOf("live") >= 0) {
                this.live = true;
            }
        }
        catch (Exception e) {
            Aladin.trace(3, "No properties file found ...");
            return false;
        }
        return true;
    }

    protected void setSpecificParams(TreeObjDir gluSky) {
        this.type = 16;
        this.video = this.aladin.configuration.getCMVideo();
        this.inFits = gluSky.isFits();
        this.inJPEG = gluSky.isJPEG();
        this.inPNG = gluSky.isPNG();
        this.truePixels = gluSky.isTruePixels();
        this.color = gluSky.isColored();
        this.cube = gluSky.isCube();
        this.scanProperties();
        this.scanMetadata();
        gluSky.reset();
    }

    protected int getTileMode() {
        if (this.isTruePixels()) {
            return 1;
        }
        if (this.inPNG) {
            return 4;
        }
        return 0;
    }

    public PlanBG(Aladin aladin, String path, String label, Coord c, double radius, String startingTaskId) {
        TreeObjDir gsky;
        block2: {
            super(aladin);
            this.segmentIAUConv = false;
            this.segmentLenFactor = 1.0f;
            this.segmentThickness = 1;
            this.segmentDensityFactor = 1.0f;
            this.oc = null;
            this.drawMode = 0;
            this.prop = null;
            this.gluTag = null;
            this.urlSuffix = null;
            this.version = "";
            this.minOrder = 3;
            this.maxOrder = 14;
            this.hasDrawnSomething = false;
            this.allWaitingKeysDrawn = false;
            this.useCache = true;
            this.cube = false;
            this.color = false;
            this.colorPNG = false;
            this.colorUnknown = false;
            this.fitsGzipped = false;
            this.truePixels = false;
            this.inFits = false;
            this.inJPEG = false;
            this.inPNG = false;
            this.hasMoc = false;
            this.hasHpxFinder = false;
            this.frameOrigin = 0;
            this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
            this.live = false;
            this.loadMocNow = false;
            this.pixelRange = null;
            this.pixelCut = null;
            this.transferFct4Fits = 3;
            this.transferFct4Preview = 3;
            this.flagNoTarget = false;
            this.hasAllSky = true;
            this.tileOrder = -1;
            this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
            this.specificProj = false;
            this.polaScaleFactor = 40;
            this.memSize = 0L;
            this.testMoc = false;
            this.testHpxFinder = false;
            this.nbCheckSite = 0;
            this.frameHipsProperties = null;
            this.flagClearBuf = false;
            this.planBgRgb = null;
            this.flagRecut = true;
            this.flagRecutRadius = 0.0;
            this.flagRecutCoo = null;
            this.cacheName = null;
            this.dirCache = null;
            this.flagCache = false;
            this.nbReady = 0;
            this.nbFlush = 0;
            this.lastGc = 0L;
            this.lastMemP = 0L;
            this.lastMemI = 0L;
            this.memCpt = true;
            this.firstSubtil = true;
            this.RES = null;
            this.allSkyOrder = -1;
            this.xy2hpx = null;
            this.hpx2xy = null;
            this.lastTouch = 0L;
            this.lastIz = -1L;
            this.lastMaxOrder = 3;
            this.oLosangeOrder = -1;
            this.hasMoreDetails = true;
            this.children = null;
            this.first1 = false;
            this.lastHistID = -1;
            this.histRed = new double[256];
            this.histGreen = new double[256];
            this.histBlue = new double[256];
            this.timer = null;
            this.readyAfterDraw = false;
            this.readyDone = false;
            this.priority = 0;
            this.computeDrawFast = true;
            this.lastMustDrawFast = true;
            this.nStat = 0;
            this.statTimeDisplayArray = new long[5];
            this.first = true;
            this.fading = false;
            this.op = 0.0f;
            this.timerLastDrawBG = 0L;
            this.nbgzip = 0;
            this.timegzip = 0L;
            this.nbnogzip = 0;
            this.timenogzip = 0L;
            this.gzipMode = 0;
            this.oLoading = false;
            this.cumulTimeLoadNet = 0L;
            this.cumulTimeLoadCache = 0L;
            this.cumulTimeWriteCache = 0L;
            this.cumulTimeDraw = 0L;
            this.cumulTimeStream = 0L;
            this.cumulTimeJPEG = 0L;
            this.cumulTimePixel = 0L;
            this.nbLoadNet = 0;
            this.nbLoadCache = 0;
            this.nbWriteCache = 0;
            this.nbImgDraw = 0;
            this.nByteReadNet = 0L;
            this.nByteReadCache = 0L;
            this.nByteWriteCache = 0L;
            this.nbImgCreated = 0;
            this.nbImgInBuf = 0;
            this.nbCreated = 0;
            this.nbAborted = 0;
            this.nbFree = 0;
            this.startingTaskId = startingTaskId;
            this.initCache();
            Aladin.trace(2, "Creating allSky directory plane [" + path + "]");
            this.type = 16;
            this.video = aladin.configuration.getCMVideo();
            File f = new File(path);
            this.url = f.getAbsolutePath();
            this.survey = f.getName();
            this.maxOrder = 3;
            this.useCache = false;
            this.label = label;
            gsky = null;
            try {
                gsky = new TreeObjDir(aladin, this.url);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
        this.paramByTreeNode(gsky, c, radius);
        this.scanProperties();
        this.scanMetadata();
        Aladin.trace(3, "HiPS local... frame=" + Localisation.getFrameName(this.frameOrigin) + " " + this + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected PlanBG(Aladin aladin, URL u, String label, Coord c, double radius, String startingTaskId) {
        TreeObjDir gsky;
        block3: {
            super(aladin);
            this.segmentIAUConv = false;
            this.segmentLenFactor = 1.0f;
            this.segmentThickness = 1;
            this.segmentDensityFactor = 1.0f;
            this.oc = null;
            this.drawMode = 0;
            this.prop = null;
            this.gluTag = null;
            this.urlSuffix = null;
            this.version = "";
            this.minOrder = 3;
            this.maxOrder = 14;
            this.hasDrawnSomething = false;
            this.allWaitingKeysDrawn = false;
            this.useCache = true;
            this.cube = false;
            this.color = false;
            this.colorPNG = false;
            this.colorUnknown = false;
            this.fitsGzipped = false;
            this.truePixels = false;
            this.inFits = false;
            this.inJPEG = false;
            this.inPNG = false;
            this.hasMoc = false;
            this.hasHpxFinder = false;
            this.frameOrigin = 0;
            this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
            this.live = false;
            this.loadMocNow = false;
            this.pixelRange = null;
            this.pixelCut = null;
            this.transferFct4Fits = 3;
            this.transferFct4Preview = 3;
            this.flagNoTarget = false;
            this.hasAllSky = true;
            this.tileOrder = -1;
            this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
            this.specificProj = false;
            this.polaScaleFactor = 40;
            this.memSize = 0L;
            this.testMoc = false;
            this.testHpxFinder = false;
            this.nbCheckSite = 0;
            this.frameHipsProperties = null;
            this.flagClearBuf = false;
            this.planBgRgb = null;
            this.flagRecut = true;
            this.flagRecutRadius = 0.0;
            this.flagRecutCoo = null;
            this.cacheName = null;
            this.dirCache = null;
            this.flagCache = false;
            this.nbReady = 0;
            this.nbFlush = 0;
            this.lastGc = 0L;
            this.lastMemP = 0L;
            this.lastMemI = 0L;
            this.memCpt = true;
            this.firstSubtil = true;
            this.RES = null;
            this.allSkyOrder = -1;
            this.xy2hpx = null;
            this.hpx2xy = null;
            this.lastTouch = 0L;
            this.lastIz = -1L;
            this.lastMaxOrder = 3;
            this.oLosangeOrder = -1;
            this.hasMoreDetails = true;
            this.children = null;
            this.first1 = false;
            this.lastHistID = -1;
            this.histRed = new double[256];
            this.histGreen = new double[256];
            this.histBlue = new double[256];
            this.timer = null;
            this.readyAfterDraw = false;
            this.readyDone = false;
            this.priority = 0;
            this.computeDrawFast = true;
            this.lastMustDrawFast = true;
            this.nStat = 0;
            this.statTimeDisplayArray = new long[5];
            this.first = true;
            this.fading = false;
            this.op = 0.0f;
            this.timerLastDrawBG = 0L;
            this.nbgzip = 0;
            this.timegzip = 0L;
            this.nbnogzip = 0;
            this.timenogzip = 0L;
            this.gzipMode = 0;
            this.oLoading = false;
            this.cumulTimeLoadNet = 0L;
            this.cumulTimeLoadCache = 0L;
            this.cumulTimeWriteCache = 0L;
            this.cumulTimeDraw = 0L;
            this.cumulTimeStream = 0L;
            this.cumulTimeJPEG = 0L;
            this.cumulTimePixel = 0L;
            this.nbLoadNet = 0;
            this.nbLoadCache = 0;
            this.nbWriteCache = 0;
            this.nbImgDraw = 0;
            this.nByteReadNet = 0L;
            this.nByteReadCache = 0L;
            this.nByteWriteCache = 0L;
            this.nbImgCreated = 0;
            this.nbImgInBuf = 0;
            this.nbCreated = 0;
            this.nbAborted = 0;
            this.nbFree = 0;
            this.startingTaskId = startingTaskId;
            this.initCache();
            Aladin.trace(2, "Creating allSky http plane [" + u + "]");
            this.type = 16;
            this.video = aladin.configuration.getCMVideo();
            this.url = u.toString();
            this.url = this.checkDynHiPS(this.url);
            this.maxOrder = 3;
            this.useCache = true;
            this.local = false;
            this.co = c;
            this.coRadius = radius;
            gsky = null;
            try {
                gsky = new TreeObjDir(aladin, this.url);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
        this.paramByTreeNode(gsky, c, radius);
        int n = this.url.length();
        if (this.url.endsWith("/")) {
            --n;
        }
        this.survey = this.label != null && this.label.length() > 0 ? this.label : this.url.substring(this.url.lastIndexOf(47, n - 1) + 1, n);
        this.scanProperties();
        this.scanMetadata();
        Aladin.trace(3, "HiPS http... " + this + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected boolean isDynHiPS() {
        return this.urlSuffix != null;
    }

    protected String checkDynHiPS(String url) {
        int i = url.indexOf("_HIPS_");
        if (i < 0) {
            return url;
        }
        this.urlSuffix = url.substring(i + 7);
        if ((url = url.substring(0, i)).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.id = "DIRECT/" + System.currentTimeMillis() / 1000L;
        Aladin.trace(1, "Dynamical HiPS detected ! id=" + this.id + " param=[" + this.urlSuffix + "]");
        return url;
    }

    protected void paramByTreeNode(TreeObjDir gSky, Coord c, double radius) {
        if (this.label != null && this.label.trim().length() > 0) {
            this.setLabel(this.label);
        } else {
            this.setLabel(gSky.label);
        }
        this.maxOrder = gSky.getMaxOrder();
        this.inFits = gSky.isFits();
        this.inJPEG = gSky.isJPEG();
        this.inPNG = gSky.isPNG();
        this.truePixels = gSky.isTruePixels();
        this.color = gSky.isColored();
        this.cube = gSky.isCube();
        this.frameOrigin = gSky.getFrame();
        this.tileOrder = gSky.getLosangeOrder();
        this.local = gSky.isLocal();
        this.loadMocNow = gSky.loadMocNow();
        this.version = gSky.getVersion();
        this.useCache = !this.local && gSky.useCache();
        this.co = c != null ? c : gSky.getTarget();
        this.coRadius = c != null ? radius : gSky.getRadius();
    }

    @Override
    protected String getPixelInfoFromGrey(int greyLevel, int mode) {
        if (this.truePixels) {
            return super.getPixelInfoFromGrey(greyLevel, mode);
        }
        return "";
    }

    protected boolean hasMoc() {
        if (this.hasMoc || this.testMoc) {
            return this.hasMoc;
        }
        String s = this.getProperty("moc_access_url");
        if (s != null) {
            this.testMoc = true;
            this.hasMoc = true;
        } else {
            String moc = this.url + "/" + "Moc.fits";
            this.hasMoc = this.local ? new File(moc).exists() : cds.tools.Util.isUrlResponding(moc);
            this.testMoc = true;
        }
        return this.hasMoc;
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        String s;
        if (prop != null && (s = prop.get("moc_sky_fraction")) != null) {
            PlanBG.ADD(buf, "\n* Coverage: ", PlanBG.getCoverageSpace(s));
        }
        PlanBG.ADD(buf, "\n", "* HiPS order: " + this.getOrder() + "/" + this.maxOrder);
    }

    protected String getProperty(String key) {
        return this.prop == null ? null : this.prop.getProperty(key);
    }

    protected boolean hasHpxFinder() {
        if (this.hasHpxFinder || this.testHpxFinder) {
            return this.hasHpxFinder;
        }
        String s = this.getProperty("hips_progenitor_url");
        if (s != null) {
            this.testHpxFinder = true;
            this.hasHpxFinder = true;
        } else {
            String f = this.url + "/" + "HpxFinder" + "/" + "metadata.xml";
            this.hasHpxFinder = this.local ? new File(f).exists() : cds.tools.Util.isUrlResponding(f);
            this.testHpxFinder = true;
        }
        return this.hasHpxFinder;
    }

    protected void loadMoc() {
        if (this.moc == null) {
            try {
                this.loadInternalMoc();
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                return;
            }
        }
        this.aladin.calque.newPlanMOC(this.moc, this.label + " MOC", this.getUrl() + "/" + "Moc.fits");
    }

    protected void loadInternalMoc() throws Exception {
        Moc moc = this.loadInternalMoc("Moc.fits");
        if (moc instanceof SMoc) {
            this.moc = (SMoc)moc;
            this.moc.setMinOrder(3);
            this.removeHealpixOutsideMoc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Moc loadInternalMoc(String mocName) throws Exception {
        SMoc moc = null;
        String fcache = this.getCacheDir() + "/" + this.getCacheName() + "/" + mocName;
        if (!this.local && this.useCache && new File(fcache).exists()) {
            try (InputStream in = null;){
                in = new BufferedInputStream(new FileInputStream(fcache));
                moc = new SMoc();
                moc.read(in);
                Aladin.trace(3, "Loading " + this.id + " " + mocName + " from cache");
            }
            return moc;
        }
        String f = this.getUrl() + "/" + mocName;
        try (MyInputStream mis = null;){
            mis = cds.tools.Util.openAnyStream(f);
            moc = new SMoc();
            moc.read(mis);
            Aladin.trace(3, "Loading " + this.id + " " + mocName + " from net");
        }
        if (!this.local && this.useCache && moc != null) {
            moc.write(fcache);
            Aladin.trace(3, "Saving " + this.survey + " MOC in cache");
        }
        return moc;
    }

    private void removeHealpixOutsideMoc() {
        block5: {
            if (this.moc == null) {
                return;
            }
            Enumeration<String> e = this.pixList.keys();
            while (e.hasMoreElements()) {
                String k = e.nextElement();
                HealpixKey h = this.pixList.get(k);
                if (h == null || h.npix == -1L || this.moc.isIntersecting(h.order, h.npix)) continue;
                h.abort();
                this.pixList.remove(k);
            }
            if ((this.co == null || this.flagNoTarget) && !this.moc.isEmpty() && this.frameOrigin == 0) {
                try {
                    MocCell cell = this.moc.iterator().next();
                    double[] res = CDSHealpix.pix2ang_nest(cell.order, cell.start);
                    double[] radec = CDSHealpix.polarToRadec(new double[]{res[0], res[1]});
                    this.co = new Coord(radec[0], radec[1]);
                }
                catch (Exception e1) {
                    if (Aladin.levelTrace < 3) break block5;
                    e1.printStackTrace();
                }
            }
        }
    }

    protected void loadProgen() {
        String progen = this.getProperty("hips_progenitor_url");
        if (progen == null) {
            progen = this.url + "/" + "HpxFinder";
        }
        this.aladin.execAsyncCommand("'Details " + this.label + "'=load " + progen);
    }

    protected int getFrameDrawing() {
        return this.frameDrawing;
    }

    protected void setFrameDrawing(int frame) {
        this.frameDrawing = frame;
        if (this.projd.frame != this.getCurrentFrameDrawing()) {
            this.projd.frame = this.getCurrentFrameDrawing();
            this.syncProjLocal();
            this.aladin.view.repaintAll();
        }
    }

    @Override
    protected void syncProjLocal() {
        Coord c;
        int j;
        int m = this.aladin.view.getNbView();
        for (j = 0; j < m; ++j) {
            ViewSimple v = this.aladin.view.viewSimple[j];
            if (v.pref != this) continue;
            c = v.projLocal.getProjCenter();
            v.projLocal.frame = this.projd.frame;
            if (this.projd.frame != 0) {
                c = Localisation.frameToFrame(c, 0, this.projd.frame);
            }
            v.projLocal.modify(this.projd.label, this.projd.modeCalib, c.al, c.del, this.projd.rm, this.projd.rm, this.projd.cx, this.projd.cy, this.projd.r, this.projd.r, this.projd.rot, this.projd.sym, this.projd.t, this.projd.system);
            v.newView(1);
        }
        for (j = this.aladin.view.viewMemo.size() - 1; j >= 0; --j) {
            ViewMemoItem memo = this.aladin.view.viewMemo.memo[j];
            if (memo == null || memo.pref != this) continue;
            c = memo.projLocal.getProjCenter();
            memo.projLocal.frame = this.projd.frame;
            if (this.projd.frame != 0) {
                c = Localisation.frameToFrame(c, 0, this.projd.frame);
            }
            memo.projLocal.modify(this.projd.label, this.projd.modeCalib, c.al, c.del, this.projd.rm, this.projd.rm, this.projd.cx, this.projd.cy, this.projd.r, this.projd.r, this.projd.rot, this.projd.sym, this.projd.t, this.projd.system);
        }
    }

    protected int getCurrentFrameDrawing() {
        if (this.frameDrawing == 0) {
            return this.aladin.localisation.getFrame();
        }
        return cds.tools.Util.indexInArrayOf(Localisation.FRAME[this.frameDrawing], Localisation.REPERE);
    }

    public int getFrameOrigin() {
        return this.frameOrigin;
    }

    protected static boolean isPlanHpxFinder(String path) {
        File f = new File(path);
        return f.getName().equals("HpxFinder") && f.isDirectory();
    }

    protected void suite() {
        boolean isAPlanet;
        if (this.label == null || this.label.trim().length() == 0) {
            this.setLabel(this.id != null ? this.id : this.survey);
        }
        int defaultProjType = this.aladin.projSelector.getProjType();
        if (this.co == null) {
            this.flagNoTarget = true;
            this.co = new Coord(0.0, 0.0);
            this.co = Localisation.frameToFrame(this.co, this.aladin.localisation.getFrame(), 0);
            this.coRadius = 220.0;
        }
        if (this.coRadius <= 0.0) {
            this.coRadius = 220.0;
        }
        this.objet = this.co + "";
        boolean isPanorama = this.isPanorama();
        boolean longAsc = isAPlanet = this.isPlanet();
        int projection = isPanorama ? 17 : (isAPlanet ? 1 : defaultProjType);
        this.specificProj = isAPlanet;
        Projection p = new Projection("hips", 2, this.co.al, this.co.del, 240.0, 240.0, 250.0, 250.0, 500.0, 500.0, 0.0, longAsc, projection, Calib.FK5, this);
        p.frame = this.getCurrentFrameDrawing();
        this.setNewProjD(p);
        this.typeCM = this.aladin.configuration.getCMMap();
        this.transferFct4Preview = this.aladin.configuration.getCMFct();
        this.transfertFct = this.truePixels ? this.transferFct4Fits : this.transferFct4Preview;
        this.video = this.aladin.configuration.getCMVideo();
        if (Aladin.levelTrace == 6) {
            System.err.println("WARNING: Cache off for perf tests on " + this.id);
            this.useCache = false;
        }
        this.setDefaultZoom(this.co, this.coRadius);
        this.suiteSpecific();
        this.launchLoading();
    }

    protected void launchLoading() {
        this.threading();
        this.log();
    }

    @Override
    protected boolean hasSpecificProj() {
        return this.specificProj;
    }

    protected void setSpecificProj(boolean flag) {
        this.specificProj = flag;
    }

    protected String getHipsFrame() {
        String frame;
        if (this.prop != null && (frame = this.prop.getProperty("hips_frame")) != null) {
            return frame;
        }
        return Localisation.getFrameName(this.frameOrigin);
    }

    protected boolean isPanorama() {
        if (this.prop == null) {
            return false;
        }
        String s = this.prop.getProperty("hips_frame");
        if (!this.isPlanet(s)) {
            return false;
        }
        return this.id.toLowerCase().indexOf("/pan") >= 0 || s.toLowerCase().indexOf("pan") >= 0;
    }

    protected boolean isPlanet() {
        if (this.prop == null) {
            return false;
        }
        String s = this.prop.getProperty("hips_frame");
        return this.isPlanet(s);
    }

    protected boolean isPlanet(String frame) {
        return frame != null && cds.tools.Util.indexInArrayOf(frame, SKYFRAME, true) < 0;
    }

    protected String getPlanetSys() {
        if (!this.isPlanet()) {
            return null;
        }
        return this.prop.getProperty("hips_frame");
    }

    protected void suiteSpecific() {
        this.pixelMin = 0.0;
        this.dataMin = 0.0;
        this.pixelMax = 255.0;
        this.dataMax = 255.0;
        this.selected = true;
        this.active = true;
        this.isOldPlan = false;
        this.pixList = new Hashtable(1000);
        if (this.error == null) {
            this.loader = new HealpixLoader();
        }
        this.RGBControl = new int[this.RGBCONTROL.length];
        for (int i = 0; i < this.RGBCONTROL.length; ++i) {
            this.RGBControl[i] = this.RGBCONTROL[i];
        }
        this.aladin.endMsg();
        this.creatDefaultCM();
        this.resetStats();
    }

    protected void setDefaultZoom(Coord c, double radius) {
        this.setDefaultZoom(c, radius, this.aladin.view.getCurrentView().getWidth());
    }

    protected void setDefaultZoom(Coord c, double radius, int width) {
        this.initZoom = -1.0;
        if (radius > 0.0 && c != null) {
            double projPixelRes = this.projd.rm / 60.0 / this.projd.r;
            double taille = (double)width * projPixelRes;
            double z = taille / radius;
            this.initZoom = this.aladin.calque.zoom.getNearestZoomFct(z);
        }
        if (this.initZoom == -1.0) {
            this.initZoom = c == null ? 0.03125 : 16.0;
        }
        Aladin.trace(4, "PlanBG.setDefaultZoom(" + c + "," + Coord.getUnit(radius) + ") => zoom = " + this.initZoom);
    }

    protected void log() {
        this.aladin.log(Plan.Tp[this.type], this.label);
    }

    protected void initCache() {
        if (cacheSize == -1L) {
            cacheSize = this.aladin.configuration.getHpxCacheSize();
            Aladin.trace(3, "Cache Size => " + cacheSize);
        }
        if (Aladin.MAXMEM < 50L) {
            Aladin.error("Full sky Aladin mode requires atleast 64MB of RAM\nWe strongly suggest to adjust the JAVA memory parameter and relaunch Aladin.\nSee the corresponding Aladin FAQ entry available via the Help menu");
        }
    }

    public boolean checkSite(boolean withTrace) {
        if (this.nbCheckSite >= 3) {
            return false;
        }
        if (this.gluTag == null || this.gluTag.startsWith("__") || this.gluTag.startsWith("DIRECT/")) {
            return false;
        }
        this.aladin.glu.checkIndirection(this.gluTag, "/properties");
        URL u = this.aladin.glu.getURL(this.gluTag, "", false, true, 1);
        if (u == null) {
            return false;
        }
        String url1 = "" + u;
        if (url1.equals(this.url)) {
            return false;
        }
        ++this.nbCheckSite;
        if (withTrace) {
            this.aladin.command.console("!!! Dynamic Web server site switching => " + url1);
            Aladin.trace(2, "Plan " + this.label + " Dynamic Web server site switching: from " + this.url + " to " + url1);
        }
        this.url = url1;
        this.resetStats();
        return true;
    }

    @Override
    public ArrayList<String> getMirrorsUrl() {
        if (this.gluTag == null || this.gluTag.startsWith("__") || this.gluTag.startsWith("DIRECT/")) {
            return null;
        }
        ArrayList<String> a = this.aladin.glu.getAllUrls(this.gluTag);
        if (a.size() < 2) {
            return null;
        }
        return a;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    protected void planReady(boolean ready) {
        super.planReady(ready);
        this.setPourcent(0.0);
        this.flagOk = ready;
        this.aladin.synchroPlan.stop(this.startingTaskId);
        if (this.co != null) {
            this.aladin.view.setRepere(this.co);
        }
        this.planReadyMoc();
    }

    protected void planReadyMoc() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Healpix hpx;
                    if (PlanBG.this.loadMocNow) {
                        PlanBG.this.loadMoc();
                    } else if (PlanBG.this.hasMoc()) {
                        PlanBG.this.loadInternalMoc();
                    }
                    if (PlanBG.this.hasMoc() && PlanBG.this.co != null && !PlanBG.this.moc.contains(hpx = new Healpix(), PlanBG.this.co.al, PlanBG.this.co.del)) {
                        PlanBG.this.co.al = Double.parseDouble(PlanBG.this.prop.getFirst("hips_initial_ra"));
                        PlanBG.this.co.del = Double.parseDouble(PlanBG.this.prop.getFirst("hips_initial_dec"));
                        PlanBG.this.aladin.view.setRepere(PlanBG.this.co);
                        Aladin cfr_ignored_0 = PlanBG.this.aladin;
                        Aladin.trace(4, "PlanBG.planReadyMoc(): default target out of HiPS moc => moving on " + PlanBG.this.co);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    protected boolean waitForPlan() {
        return this.error == null;
    }

    @Override
    protected void setCM(Object cm) {
        this.cm = (ColorModel)cm;
        this.changeImgID();
    }

    @Override
    protected boolean Free() {
        String stat = this.getShortStats();
        if (stat != null) {
            this.aladin.log("HealpixStats", stat);
            Aladin.trace(4, "PlanBG.Free() stat => " + stat);
            this.nbLoadCache = 0;
            this.nbLoadNet = 0;
        }
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.frameOrigin = 0;
        this.FreePixList();
        this.prop = null;
        return super.Free();
    }

    @Override
    protected void setFmt() {
    }

    protected void seeHipsProp() {
        block3: {
            try {
                if (this.frameHipsProperties == null) {
                    this.frameHipsProperties = new FrameHipsProperties(this);
                }
                this.frameHipsProperties.seeHeaderFits();
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
    }

    protected void FreePixList() {
        try {
            if (this.pixList != null) {
                Enumeration<HealpixKey> e = this.pixList.elements();
                while (e.hasMoreElements()) {
                    HealpixKey healpix = e.nextElement();
                    if (healpix == null) continue;
                    if (this.useCache && healpix.shouldBeCached()) {
                        healpix.write();
                    }
                    healpix.free();
                }
                this.pixList.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getPolaScaleFactor() {
        return this.polaScaleFactor;
    }

    protected void setPolaScaleFactor(int polaScaleFactor) {
        this.polaScaleFactor = polaScaleFactor;
    }

    protected void clearBuf() {
        Enumeration<HealpixKey> e = this.pixList.elements();
        while (e.hasMoreElements()) {
            HealpixKey healpix = e.nextElement();
            if (healpix == null) continue;
            healpix.clearBuf();
        }
        this.gc();
    }

    @Override
    protected boolean pixelsOriginIntoCache() {
        if (this.flagClearBuf) {
            return true;
        }
        this.clearBuf();
        this.changeImgID();
        this.flagClearBuf = true;
        return true;
    }

    @Override
    protected boolean hasOriginalPixels() {
        return this.isTruePixels();
    }

    @Override
    protected double getInvPixel(double pix8) {
        if (this.width == 0 && this.local && this.truePixels) {
            this.loadOneKey();
        }
        return super.getInvPixel(pix8);
    }

    private void loadOneKey() {
        try {
            int order = Util.getMaxOrderByPath(this.url);
            File f = new File(HealpixKey.getFilePath(this.url, order, 0L, 0));
            f = f.getParentFile().getParentFile();
            File[] list = f.listFiles();
            list = list[0].listFiles();
            String name = list[0].getName();
            int i = name.lastIndexOf(46);
            int npix = Integer.parseInt(name.substring(4, i));
            new HealpixKey(this, order, npix, 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void flip(int methode) throws Exception {
        this.setSpecificProj(true);
        boolean sym = methode == 1 || methode == 2 ? !this.projd.sym : this.projd.sym;
        double angle = methode == 0 || methode == 2 ? this.projd.rot + 180.0 : this.projd.rot;
        Projection p = this.projd;
        this.modifyProj(null, 3, p.alphai, p.deltai, p.rm1, p.cx, p.cy, p.r1, angle, sym, p.t, p.system);
        this.aladin.view.newView(1);
        this.aladin.view.repaintAll();
    }

    protected void addRecutListener(PlanBGRgb p) {
        this.planBgRgb = p;
    }

    protected boolean hasRecutListener() {
        return this.planBgRgb != null;
    }

    protected PlanBGRgb getRecutListener() {
        return this.planBgRgb;
    }

    @Override
    protected boolean recut(double min, double max, boolean autocut) {
        this.FreePixList();
        this.changeImgID();
        double tmpRangeMin = this.dataMin;
        double tmpRangeMax = this.dataMax;
        this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, min, max, autocut, 0, 0, 0, 0);
        if (tmpRangeMin != tmpRangeMax) {
            this.dataMin = tmpRangeMin;
            this.dataMax = tmpRangeMax;
        }
        if (this.pixelsOrigin != null) {
            int size = this.pixelsOrigin.length / (Math.abs(this.bitpix) / 8);
            if (this.pixels == null || this.pixels.length != size) {
                this.pixels = new byte[size];
            }
            this.to8bits(this.pixels, 0, this.pixelsOrigin, size, this.bitpix, this.pixelMin, this.pixelMax, false);
            this.resetHist();
        }
        if (this.planBgRgb != null) {
            this.planBgRgb.recut();
        }
        return true;
    }

    protected void setMem() {
    }

    @Override
    protected boolean setActivated(boolean flag) {
        if (flag && this.aladin.calque.hasHpxGrid()) {
            System.out.println(this.getStats());
        }
        return super.setActivated(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCacheName() {
        if (this.cacheName != null) {
            return this.cacheName;
        }
        try {
            String s;
            if (this.id != null && this.id.startsWith("DIRECT/")) {
                s = this.id;
                if (s.startsWith("ivo://")) {
                    s = s.substring(6);
                }
            } else {
                MyProperties prop = new MyProperties();
                String urlFile = this.url + "/" + "properties";
                if (this.isDynHiPS()) {
                    urlFile = urlFile + "?" + this.urlSuffix;
                }
                InputStreamReader in = null;
                try {
                    in = new InputStreamReader((InputStream)cds.tools.Util.openAnyStream(urlFile), "UTF-8");
                    prop.load(in);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                s = PlanBG.getHiPSID(prop);
            }
            s = s.replace(":", "_");
            s = s.replace("/", "_");
            s = s.replace("\\", "_");
            s = s.replace("?", "_");
            s = s.replace("#", "_");
            this.cacheName = s = s.replace("&", "_");
        }
        catch (Exception e) {
            this.cacheName = this.survey + this.version;
        }
        Aladin.trace(4, "getCacheName(): Cache name = [" + this.cacheName + "]");
        return this.cacheName;
    }

    protected String getCacheDir() {
        if (this.flagCache) {
            return this.dirCache;
        }
        this.flagCache = true;
        if (!this.aladin.createCache()) {
            return null;
        }
        String dir = System.getProperty("user.home") + cds.tools.Util.FS + Aladin.CACHE + cds.tools.Util.FS + "Cache";
        File f = new File(dir);
        if (!f.isDirectory() && !f.mkdir()) {
            return null;
        }
        f = new File(dir = dir + cds.tools.Util.FS + CACHE);
        if (!f.isDirectory() && !f.mkdir()) {
            return null;
        }
        this.dirCache = dir;
        return dir;
    }

    protected static String getCacheDirStatic() {
        return System.getProperty("user.home") + cds.tools.Util.FS + Aladin.CACHE + cds.tools.Util.FS + "Cache" + cds.tools.Util.FS + CACHE;
    }

    protected static void setMaxCacheSize(long maxCacheSize) {
        if (maxCacheSize < 524288L) {
            maxCacheSize = 524288L;
        }
        MAXCACHE = maxCacheSize;
        Aladin.trace(4, "PlanBG.setMaxCacheSize() => " + MAXCACHE / 1024L + "MB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long getCacheSize() {
        Object object = cacheLock;
        synchronized (object) {
            return cacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addInCache(long size) {
        Object object = cacheLock;
        synchronized (object) {
            cacheSize += size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCacheSize(long size) {
        Object object = cacheLock;
        synchronized (object) {
            cacheSize = size;
        }
    }

    static synchronized void scanCache() {
        if (cacheSize != -1L && cacheSize < MAXCACHE) {
            return;
        }
        PlanBG.cleanCache();
    }

    public static synchronized void cleanCache() {
        if (scanCache != null) {
            return;
        }
        String dir = PlanBG.getCacheDirStatic();
        if (dir == null) {
            PlanBG.setCacheSize(0L);
            return;
        }
        File ft = new File(Cache.getCacheDir() + cds.tools.Util.FS + "ScanRunning.bin");
        if (ft.exists()) {
            long t = System.currentTimeMillis();
            if (t - ft.lastModified() < 3600L) {
                ft.setLastModified(t);
            } else {
                Aladin.trace(4, "Detect concurrent scanning HiPS cache => abort");
                return;
            }
        }
        try {
            new RandomAccessFile(ft, "rw").close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        scanCache = new Thread("Scan cache"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                3.currentThread().setPriority(1);
                long size = 0L;
                long t = System.currentTimeMillis();
                String dir = PlanBG.getCacheDirStatic();
                Aladin.trace(3, "Scanning HiPS cache...");
                File[] fold = new File(dir).listFiles();
                for (int i = 0; i < fold.length; ++i) {
                    if (!fold[i].isDirectory() || !fold[i].getName().endsWith(".old")) continue;
                    Aladin.trace(4, "PlanBG.scanCache(): removing folder " + fold[i].getName() + "...");
                    cds.tools.Util.deleteDir(fold[i]);
                }
                Vector<FileItem> listCache = new Vector<FileItem>(2000);
                size = PlanBG.getCacheSize(new File(dir), listCache);
                size += PlanBG.getCacheSizePlanHealpix(new File(PlanHealpix.getCacheDirPath()), listCache);
                try {
                    Collections.sort(listCache, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1 == null) {
                                return -1;
                            }
                            if (o2 == null) {
                                return 1;
                            }
                            long t1 = ((FileItem)o1).date;
                            long t2 = ((FileItem)o2).date;
                            return t1 == t2 ? 0 : (t1 > t2 ? 1 : -1);
                        }
                    });
                    Enumeration<FileItem> e = listCache.elements();
                    while (e.hasMoreElements() && size > 3L * MAXCACHE / 4L) {
                        FileItem fi = e.nextElement();
                        File f = fi.f;
                        if (fi.hasBeenModified() || size <= 3L * MAXCACHE / 4L) continue;
                        Aladin.trace(4, "PlanBG.scanCache(): removing " + f + " (" + fi.date + ")");
                        if (f.isFile()) {
                            size -= f.length() / 1024L;
                            if (fi.hasBeenModified()) {
                                throw new Exception("File :" + f.getAbsolutePath());
                            }
                            f.delete();
                            continue;
                        }
                        if (!f.isDirectory()) continue;
                        long dirSize = cds.tools.Util.dirSize(f) / 1024L;
                        size -= dirSize;
                        if (fi.hasBeenModified()) {
                            throw new Exception("Dir :" + f.getAbsolutePath());
                        }
                        cds.tools.Util.deleteDir(f);
                    }
                    Aladin.trace(3, " => Cache size=" + cds.tools.Util.getUnitDisk(size * 1024L) + " maxCache=" + cds.tools.Util.getUnitDisk(MAXCACHE * 1024L) + " scan in " + (System.currentTimeMillis() - t) + "ms");
                    PlanBG.setCacheSize(size);
                }
                catch (Exception e1) {
                    Aladin.trace(3, "Simultaneous access on cache => Clean aborted for avoiding conflict" + (e1.getMessage() != null ? " => " + e1.getMessage() : ""));
                }
                finally {
                    File ft = new File(Cache.getCacheDir() + cds.tools.Util.FS + "ScanRunning.bin");
                    ft.delete();
                    scanCache = null;
                }
            }
        };
        scanCache.start();
    }

    static void clearCache() {
        String dir = PlanBG.getCacheDirStatic();
        if (dir != null) {
            cds.tools.Util.deleteDir(new File(dir));
        }
        if ((dir = PlanHealpix.getCacheDirPath()) != null) {
            cds.tools.Util.deleteDir(new File(dir));
        }
        PlanBG.setCacheSize(0L);
    }

    public static long getCacheSize(File dir, Vector<FileItem> listCache) {
        long size = 0L;
        File[] f = dir.listFiles();
        for (int i = 0; f != null && i < f.length; ++i) {
            if (++NBFILE % 100L == 0L) {
                cds.tools.Util.pause(50);
            }
            if (f[i].isDirectory()) {
                long n = PlanBG.getCacheSize(f[i], listCache);
                if (n == 0L) {
                    f[i].delete();
                    continue;
                }
                size += n;
                continue;
            }
            size += f[i].length() / 1024L;
            if (listCache == null) continue;
            listCache.addElement(new FileItem(f[i]));
        }
        return size;
    }

    private static long getCacheSizePlanHealpix(File dir, Vector<FileItem> listCache) {
        File[] f = dir.listFiles();
        long size = 0L;
        for (int i = 0; f != null && i < f.length; ++i) {
            if (!f[i].isDirectory()) continue;
            size += cds.tools.Util.dirSize(f[i]);
            listCache.addElement(new FileItem(f[i]));
            cds.tools.Util.pause(100);
        }
        return size / 1024L;
    }

    protected String key(HealpixKey h) {
        return this.key(h.order, h.npix, h.z);
    }

    protected String key(int order, long npix) {
        return order + "/" + npix;
    }

    protected String key(int order, long npix, int z) {
        return order + "/" + npix + (z <= 0 ? "" : "_" + z);
    }

    public HealpixKey askForHealpix(int order, long npix) {
        this.readyAfterDraw = false;
        HealpixKey pixAsk = this.drawMode == 1 ? new HealpixKeyPol(this, order, npix) : new HealpixKey(this, order, npix);
        this.pixList.put(this.key(order, npix), pixAsk);
        return pixAsk;
    }

    protected void gc() {
        long t = System.currentTimeMillis();
        if (t - this.lastGc < 1000L) {
            return;
        }
        this.lastGc = t;
        if (this.aladin.getMem() < 256.0) {
            if (this.memCpt) {
                this.lastMemP = Runtime.getRuntime().freeMemory();
            } else {
                this.lastMemI = Runtime.getRuntime().freeMemory();
            }
            if (Math.abs(this.lastMemP - this.lastMemI) < (long)MEMREQUIREDFORGC) {
                return;
            }
        }
        this.nbFlush = 0;
        this.memCpt = !this.memCpt;
        this.aladin.gcIfRequired();
    }

    protected void purge(HealpixKey healpix) {
        this.nbFlush += healpix.free();
        if (this.nbFlush > 20) {
            this.gc();
        }
        this.pixList.remove(this.key(healpix));
    }

    protected void tryWakeUp() {
        this.loader.wakeUp();
    }

    protected HealpixKey getHealpixLowLevel(int order, long npix, int z, int mode) {
        HealpixKey h = this.pixList.get(this.key(order, npix, z));
        if (h == null) {
            h = new HealpixKey(this, order, npix, z, mode);
            this.pixList.put(this.key(order, npix, z), h);
        }
        if (h.getStatus() != 6) {
            return null;
        }
        return h;
    }

    protected HealpixKey getHealpix(int order, long npix, boolean flagLoad) {
        return this.getHealpix(order, npix, (int)this.getZ(), flagLoad);
    }

    protected HealpixKey getHealpix(int order, long npix, int z, boolean flagLoad) {
        HealpixKey healpix = this.pixList.get(this.key(order, npix, z));
        if (healpix != null) {
            return healpix;
        }
        healpix = this.getHealpixFromAllSky(order, npix);
        if (healpix != null) {
            return healpix;
        }
        if (flagLoad) {
            return this.askForHealpix(order, npix);
        }
        return null;
    }

    protected HealpixKey getHealpixFromAllSky(int order, long npix) {
        if (order > 3) {
            return null;
        }
        HealpixKey allsky = this.pixList.get(this.key(this.getMinOrder(), -1L));
        if (allsky == null || allsky.getStatus() != 6) {
            return null;
        }
        int orderLosange = this.getTileOrder();
        if (orderLosange > 0 && orderLosange <= this.getAllSkyOrder(allsky)) {
            HealpixKey[] list = allsky.getPixList();
            if (list == null) {
                return null;
            }
            HealpixKey healpix = list[(int)npix];
            if (healpix != null) {
                if (this.firstSubtil) {
                    Aladin.trace(4, "PlanBG.getHealpix " + this.label + " will use Allsky for order 3 diamonds!");
                    this.firstSubtil = false;
                }
                return healpix;
            }
        }
        return null;
    }

    static long[] getNpixList(int order, Coord center, double radius) throws Exception {
        if (order == 0) {
            return ALLSKY;
        }
        return CDSHealpix.query_disc(order, center.al, center.del, Math.toRadians(radius), true);
    }

    protected Coord getCooCentre(ViewSimple v) {
        Coord center = v.getCooCentre();
        if (center == null) {
            return null;
        }
        center = Localisation.frameToFrame(center, 0, this.frameOrigin);
        return center;
    }

    protected long[] getPixListView(ViewSimple v, int order) {
        return this.getPixList(v, null, order);
    }

    protected long[] getPixList(ViewSimple v, Coord center, int order) {
        try {
            if (center == null) {
                center = this.getCooCentre(v);
            }
            double radius = v.getTaille();
            radius = radius / 2.0 * 1.43;
            return (long[])PlanBG.getNpixList(order, center, radius).clone();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected int getTileOrder() {
        if (this.tileOrder == -1) {
            return 9;
        }
        return this.tileOrder;
    }

    protected void setTileOrder(int tileOrder) {
        if (this.tileOrder != -1 || tileOrder <= 0) {
            return;
        }
        this.tileOrder = tileOrder;
    }

    protected int getAllSkyOrder(HealpixKey allsky) {
        HealpixKey[] healpix;
        if (this.allSkyOrder == -1 && allsky != null && (healpix = allsky.getPixList()) != null) {
            this.allSkyOrder = healpix[0].getLosangeOrder();
        }
        return this.allSkyOrder;
    }

    @Override
    protected boolean pixelsOriginFromDisk() {
        return this.flagOk && !this.color && this.isTruePixels();
    }

    protected int getOrder() {
        int o = Math.min(this.maxOrder(), this.maxOrder);
        if (o < this.getMinOrder()) {
            o = this.getMinOrder();
        }
        return o;
    }

    protected int maxOrder() {
        ViewSimple v = this.aladin.view.getCurrentView();
        return this.maxOrder(v);
    }

    public String getSurveyDir() {
        if (this.local) {
            return this.url;
        }
        return this.getCacheDir() + cds.tools.Util.FS + this.getCacheName();
    }

    protected String getPixelInfo(double x, double y, int mode) {
        if (!this.pixelsOriginFromDisk() || mode != 1) {
            return "";
        }
        double pixel = this.getPixelInDouble(x, y);
        if (Double.isNaN(pixel)) {
            return "";
        }
        return this.Y(pixel);
    }

    @Override
    public int getPixel8(int x, int y) {
        double pix = this.getPixelInDouble(x, y);
        return (int)((pix - this.pixelMin) * 256.0 / (this.pixelMax - this.pixelMin));
    }

    @Override
    protected double getPixelOriginInDouble(int x, int y) {
        return this.getPixelInDouble(x, y);
    }

    @Override
    protected double getPixelInDouble(int x, int y) {
        return this.getPixelInDouble((double)x, (double)y);
    }

    protected double getPixelInDouble(double x, double y) {
        if (!this.pixelsOriginFromDisk()) {
            return Double.NaN;
        }
        int bitpix = this.getBitpix();
        int mynpix = Math.abs(bitpix) / 8;
        byte[] onePixelOrigin = new byte[mynpix];
        if (!this.getOnePixelFromCache(onePixelOrigin, x, y)) {
            return Double.NaN;
        }
        return this.getPixVal(onePixelOrigin, bitpix, 0) * this.bScale + this.bZero;
    }

    protected boolean getOnePixelFromCache(byte[] pixels, double x, double y) {
        return this.getOnePixelFromCache(this.projd, pixels, x, y);
    }

    protected boolean getOnePixelFromCache(Projection projd, byte[] pixels, double x, double y) {
        double val = this.getOnePixelFromCache(projd, x, y);
        if (Double.isNaN(val)) {
            return false;
        }
        PlanBG.setPixVal(pixels, this.getBitpix(), 0, val);
        return true;
    }

    protected double getOnePixelFromCache(Projection projd, double x, double y) {
        return this.getOnePixelFromCache(projd, x, y, -1, 2);
    }

    protected double getOnePixelFromCache(Projection projd, double x, double y, int order, int mode) {
        return this.getOnePixelFromCache(projd, x, y, order, (int)this.getZ(), mode);
    }

    protected double getOnePixelFromCache(Projection projd, double x, double y, int order, int z, int mode) {
        double pixel;
        block4: {
            pixel = Double.NaN;
            if (order <= 0) {
                order = this.getOrder();
            }
            try {
                Coord coo = new Coord();
                coo.x = x;
                coo.y = y;
                projd.getCoord(coo);
                coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
                if (Double.isNaN(coo.al) || Double.isNaN(coo.del)) {
                    return Double.NaN;
                }
                double[] polar = CDSHealpix.radecToPolar(new double[]{coo.al, coo.del});
                long npixFile = CDSHealpix.ang2pix_nest(order, polar[0], polar[1]);
                pixel = this.getHealpixPixel(order, npixFile, polar[0], polar[1], z, mode);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        return pixel;
    }

    protected double getHealpixPixel(int orderFile, long npixFile, double theta, double phi, int z, int mode) {
        HealpixKey h;
        if (this.isOutMoc(orderFile, npixFile)) {
            return Double.NaN;
        }
        HealpixKey healpixKey = mode == 3 ? this.pixList.get(this.key(orderFile, npixFile, z)) : (h = this.getHealpixLowLevel(orderFile, npixFile, z, mode == 0 ? 2 : 3));
        if (h == null || h.getStatus() != 6) {
            return Double.NaN;
        }
        int order = (int)CDSHealpix.log2(h.width) + h.order;
        try {
            long healpixIdxPixel = CDSHealpix.ang2pix_nest(order, theta, phi);
            return h.getPixelValue(healpixIdxPixel, mode);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    protected double getHealpixPixel(int orderFile, long npixFile, long healpixIdxPixel, int mode) throws Exception {
        return this.getHealpixPixel(orderFile, npixFile, healpixIdxPixel, -1, mode);
    }

    protected double getHealpixPixel(int orderFile, long npixFile, long healpixIdxPixel, int z, int mode) throws Exception {
        HealpixKey h;
        if (z == -1) {
            z = (int)this.getZ();
        }
        if ((h = this.getHealpixLowLevel(orderFile, npixFile, z, mode == 1 ? 2 : 3)) == null) {
            throw new Exception("Tile " + orderFile + "/" + npixFile + " not yet ready");
        }
        return h.getPixelValue(healpixIdxPixel, mode);
    }

    protected double getHealpixClosestPixel(double ra, double dec, int order) {
        double pixel;
        block4: {
            pixel = Double.NaN;
            try {
                double[] polar = CDSHealpix.radecToPolar(new double[]{ra, dec});
                long npixFile = CDSHealpix.ang2pix_nest(order, polar[0], polar[1]);
                HealpixKey h = this.getHealpixLowLevel(order, npixFile, (int)this.getZ(), 2);
                if (h == null) {
                    return Double.NaN;
                }
                int orderPix = (int)CDSHealpix.log2(h.width) + h.order;
                long npixPixel = CDSHealpix.ang2pix_nest(orderPix, polar[0], polar[1]);
                HealpixKey h1 = this.getHealpixLowLevel(order, npixFile, (int)this.getZ(), 2);
                if (h1 == null) {
                    return Double.NaN;
                }
                pixel = h1.getPixelValue(npixPixel, 0);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        return pixel;
    }

    protected double getHealpixLinearPixel(double ra, double dec, double ra1, double dec1, int order) {
        double pixel;
        block9: {
            pixel = Double.NaN;
            try {
                int m;
                double[] polar = CDSHealpix.radecToPolar(new double[]{ra, dec});
                double[] polar1 = CDSHealpix.radecToPolar(new double[]{ra1, dec1});
                long npixFile = CDSHealpix.ang2pix_nest(order, polar[0], polar[1]);
                HealpixKey h = this.getHealpixLowLevel(order, npixFile, (int)this.getZ(), 2);
                if (h == null) {
                    return Double.NaN;
                }
                int orderPix = (int)CDSHealpix.log2(h.width) + h.order;
                long npixPixel = CDSHealpix.ang2pix_nest(orderPix, polar[0], polar[1]);
                long[] voisins = CDSHealpix.neighbours(orderPix, npixPixel);
                for (int i = m = 4; i >= 1; --i) {
                    voisins[i] = voisins[i - 1];
                }
                voisins[0] = npixPixel;
                double totalPixel = 0.0;
                double totalCoef = 0.0;
                for (int i = 0; i < m; ++i) {
                    HealpixKey h1 = h;
                    long nlpix = voisins[i];
                    long startIdx = h.npix * (long)h.width * (long)h.width;
                    long pixOffset = nlpix - startIdx;
                    if (pixOffset < 0L || pixOffset >= (long)(h.width * h.width)) {
                        long npixFile1 = nlpix / (long)(h.width * h.width);
                        HealpixKey htmp = this.getHealpixLowLevel(order, npixFile1, (int)this.getZ(), 2);
                        if (htmp == null) continue;
                        h1 = htmp;
                    }
                    try {
                        double pix = h1.getPixelValue(nlpix, 0);
                        if (Double.isNaN(pix)) continue;
                        double[] polar2 = CDSHealpix.pix2ang_nest(orderPix, nlpix);
                        double coef = Coo.distance(polar1[0], polar1[1], polar2[0], polar2[1]);
                        if (coef == 0.0) {
                            return pix;
                        }
                        double c = 1.0 / coef;
                        totalPixel += pix * c;
                        totalCoef += c;
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                pixel = totalPixel / totalCoef;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block9;
                e.printStackTrace();
            }
        }
        return pixel;
    }

    public static String getFilePath(String survey, int order, long npix) {
        return survey + cds.tools.Util.FS + "Norder" + order + cds.tools.Util.FS + "Dir" + npix / 10000L * 10000L + cds.tools.Util.FS + "Npix" + npix;
    }

    private static void fillUp(int[] npix, int nsize, int[] pos) {
        int i;
        int size = nsize * nsize;
        int[][] fils = new int[4][size / 4];
        int[] nb = new int[4];
        for (i = 0; i < size; ++i) {
            int dg = i % nsize < nsize / 2 ? 0 : 1;
            int bh = i < size / 2 ? 1 : 0;
            int quad = dg << 1 | bh;
            int j = pos == null ? i : pos[i];
            npix[j] = npix[j] << 2 | quad;
            int n = quad;
            int n2 = nb[n];
            nb[n] = n2 + 1;
            fils[quad][n2] = j;
        }
        if (size > 4) {
            for (i = 0; i < 4; ++i) {
                PlanBG.fillUp(npix, nsize / 2, fils[i]);
            }
        }
    }

    protected void createHealpixOrder(int order) throws Exception {
        if (order == 0) {
            this.hpx2xy = new int[]{0};
            this.xy2hpx = this.hpx2xy;
            return;
        }
        int nsize = (int)CDSHealpix.pow2(order);
        if (CDSHealpix.log2(nsize) != (long)order) {
            throw new Exception("Only HEALPix order power of 2 are supported");
        }
        this.xy2hpx = new int[nsize * nsize];
        this.hpx2xy = new int[nsize * nsize];
        PlanBG.fillUp(this.xy2hpx, nsize, null);
        for (int i = 0; i < this.xy2hpx.length; ++i) {
            this.hpx2xy[this.xy2hpx[i]] = i;
        }
    }

    public final int xy2hpx(int hpxOffset) {
        return this.xy2hpx[hpxOffset];
    }

    public final int hpx2xy(int xyOffset) {
        return this.hpx2xy[xyOffset];
    }

    protected void touchCache() {
        long t = System.currentTimeMillis();
        if (t - this.lastTouch < 60000L) {
            return;
        }
        this.lastTouch = t;
        String pathName = this.getCacheDir() + cds.tools.Util.FS + this.getCacheName();
        new File(pathName).setLastModified(t);
        Date d = new Date();
        d.setTime(this.lastTouch);
        Aladin.trace(4, "PlanBG.touchCache() : Date:" + d + " => " + pathName);
    }

    protected int maxOrder(ViewSimple v) {
        long iz = v.getIZ();
        if (this.lastIz == iz) {
            return this.lastMaxOrder;
        }
        this.lastIz = iz;
        int myOrder = this.getTileOrder();
        if (this.RES == null || this.oLosangeOrder != myOrder) {
            this.oLosangeOrder = myOrder;
            if (this.RES == null) {
                this.RES = new double[20];
            }
            this.lastMaxOrder = 0;
            while (this.lastMaxOrder < 20) {
                int order = this.lastMaxOrder + myOrder + 1;
                this.RES[this.lastMaxOrder] = CDSHealpix.pixRes(order) / 3600.0;
                ++this.lastMaxOrder;
            }
        }
        double pixSize = v.getPixelSize();
        this.lastMaxOrder = 0;
        while (this.lastMaxOrder < this.RES.length && this.RES[this.lastMaxOrder] > pixSize) {
            ++this.lastMaxOrder;
        }
        this.lastMaxOrder = this.adjustMaxOrder(this.lastMaxOrder, pixSize);
        return this.lastMaxOrder;
    }

    protected int adjustMaxOrder(int lastMaxOrder, double pixSize) {
        if (lastMaxOrder <= 2 && pixSize < 0.06 && this.getMinOrder() == 3) {
            lastMaxOrder = 3;
        }
        return lastMaxOrder;
    }

    protected String getFormat() {
        if (this.color) {
            if (this.inFits) {
                return "FITS RGB color";
            }
            return (this.colorPNG || this.inPNG ? "PNG" : "JPEG") + " color";
        }
        if (this.truePixels) {
            return "FITS true pixels (BITPIX=" + this.bitpix + ")";
        }
        return (this.colorPNG || this.inPNG ? "PNG" : "JPEG") + " 8 bits pixels";
    }

    protected void switchFormat() {
        if (this.truePixels) {
            this.transferFct4Fits = this.transfertFct;
        } else {
            this.transferFct4Preview = this.transfertFct;
        }
        boolean bl = this.truePixels = !this.truePixels;
        this.setPixMode(this.truePixels ? 2 : (this.inPNG ? 4 : 3));
        this.transfertFct = this.truePixels ? this.transferFct4Fits : this.transferFct4Preview;
        this.restoreCM();
        this.forceReload();
        if (this.aladin.frameCM != null) {
            this.aladin.frameCM.majCM(true);
        }
    }

    public void forceReload() {
        this.FreePixList();
        this.changeImgID();
        this.flagRecut = true;
        this.flagRecutCoo = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
        this.flagRecutRadius = this.aladin.view.getCurrentView().getTaille() / 2.0;
        this.resetHist();
    }

    protected String getMaxResolution() {
        return Coord.getUnit(this.getPixelResolution());
    }

    public int getMaxFileOrder() {
        return this.maxOrder;
    }

    public int getMaxHealpixOrder() {
        return this.maxOrder + this.getTileOrder();
    }

    public double getPixelResolution() {
        return CDSHealpix.pixRes(this.getMaxHealpixOrder()) / 3600.0;
    }

    protected boolean isFullyDrawn() {
        return this.isDrawn() && this.allWaitingKeysDrawn;
    }

    protected boolean isDrawn() {
        return this.readyDone;
    }

    protected boolean isLoading() {
        return !this.loader.isReadyForDrawing();
    }

    protected boolean hasMoreDetails() {
        return this.hasMoreDetails;
    }

    protected String getInfoDetails() {
        return this.getOrder() + "/" + this.maxOrder;
    }

    protected void setHasMoreDetails(boolean flag) {
        this.hasMoreDetails = flag;
    }

    @Override
    protected boolean isSync() {
        if (this.error != null) {
            Aladin.trace(6, "PlanBG.isSync()=true:" + this.label + " => in error (error=" + this.error + ")");
            return true;
        }
        if (!this.flagOk) {
            Aladin.trace(6, "PlanBG.isSync()=false: " + this.label + " => not ready (!flagOk)");
            return false;
        }
        if (!this.active) {
            Aladin.trace(6, "PlanBG.isSync()=true: " + this.label + "=> not active (!active)");
            return true;
        }
        if (this.getOpacityLevel() == 0.0f && !this.ref) {
            Aladin.trace(6, "PlanBG.isSync()=true: " + this.label + "=> transparent (!ref && opacity=" + this.getOpacityLevel() + ")");
            return true;
        }
        if (this.flagProcessing) {
            Aladin.trace(6, "PlanBG.isSync()=false: " + this.label + "=> is processing (flagProcessing)");
            return false;
        }
        if (this.isLoading()) {
            Aladin.trace(6, "PlanBG.isSync()=false: " + this.label + "=> is loading (isLoading())");
            return false;
        }
        return true;
    }

    @Override
    public boolean isCube() {
        return this.cube;
    }

    public boolean isColored() {
        return this.color;
    }

    public boolean isTruePixels() {
        return this.truePixels;
    }

    public boolean canbeTruePixels() {
        return this.inFits;
    }

    public boolean isLocalAllSky() {
        return this.local;
    }

    private boolean childrenReady(HealpixKey healpix, ViewSimple v, int maxOrder) {
        int nextOrder = healpix.order + 1;
        this.children = healpix.getChildren(this.children);
        for (int i = 0; i < 4; ++i) {
            if (this.isOutMoc(nextOrder, this.children[i])) continue;
            HealpixKey fils = this.getHealpix(nextOrder, this.children[i], healpix.z, false);
            if (fils == null) {
                fils = new HealpixKey(this, nextOrder, this.children[i], 0);
            }
            if (fils.isOutView(v) || fils.getStatus() == 6) continue;
            if (nextOrder == maxOrder - 1) {
                return false;
            }
            if (nextOrder >= maxOrder - 1 || this.childrenReady(fils, v, maxOrder)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void modifyProj(String label, int modeCalib, double alphai, double deltai, double rm, double cx, double cy, double r, double rot, boolean sym, int t, int system) {
        super.modifyProj(label, modeCalib, alphai, deltai, rm, cx, cy, r, rot, sym, t, system);
    }

    protected int futurGetMinOrder() {
        return this.minOrder == -1 ? 3 : this.minOrder;
    }

    protected int getMinOrder() {
        if (!this.hasAllSky || this.hasRecutListener()) {
            return this.futurGetMinOrder();
        }
        return 3;
    }

    protected void loadAllSkyNow() {
        HealpixKey allsky = this.pixList.get(this.key(this.getMinOrder(), -1L));
        if (allsky == null) {
            allsky = new HealpixAllsky(this, this.getMinOrder());
            this.pixList.put(this.key(allsky), allsky);
            try {
                allsky.loadNow();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean drawAllSky(Graphics g, ViewSimple v, BufferedImage imgb) {
        int status;
        boolean hasDrawnSomething = false;
        int z = (int)this.getZ(v);
        int order = this.getMinOrder();
        HealpixKey allsky = this.pixList.get(this.key(order, -1L, z));
        this.flagWaitAllSky = false;
        if (allsky == null) {
            allsky = this.drawMode == 1 ? new HealpixAllskyPol(this, order) : new HealpixAllsky(this, order, z);
            this.pixList.put(this.key(allsky), allsky);
            if (this.local) {
                allsky.waitLock();
                if (allsky.getStatus() == 3) {
                    allsky.loadFromNet();
                }
                allsky.unLock();
            } else {
                if (!this.useCache || !allsky.isCached()) {
                    this.tryWakeUp();
                    if (v.pref == this) {
                        this.drawBackground(g, v);
                    }
                    return true;
                }
                allsky.loadFromCache();
            }
        }
        if ((status = allsky.getStatus()) == 7) {
            this.hasAllSky = false;
            return false;
        }
        if (status == 6) {
            int i;
            long[] pixList;
            allsky.resetTimer();
            this.statNbItems = 0L;
            double taille = Math.min(v.getTailleRA(), v.getTailleDE());
            HealpixKey[] allSkyPixList = allsky.getPixList();
            if (taille < 40.0 && !v.isAllSky()) {
                pixList = this.getPixList(v, null, order);
            } else {
                pixList = new long[allSkyPixList.length];
                for (i = 0; i < pixList.length; ++i) {
                    pixList[i] = i;
                }
            }
            for (i = 0; i < pixList.length; ++i) {
                int npix = (int)pixList[i];
                HealpixKey healpix = allSkyPixList[npix];
                if (healpix == null || healpix.isOutView(v)) continue;
                if (this.drawMode == 0) {
                    healpix.draw(g, v);
                } else if (this.drawMode == 1) {
                    ((HealpixKeyPol)healpix).drawPolarisation(g, v);
                }
                ++this.statNbItems;
                hasDrawnSomething = true;
            }
            this.drawHoles(imgb, v, allsky.getPixList());
        } else {
            this.flagWaitAllSky = true;
        }
        return hasDrawnSomething;
    }

    private boolean mustDrawHoles(ViewSimple v) {
        if (this.mustDrawFast()) {
            return false;
        }
        if (!v.isAllSky()) {
            return false;
        }
        try {
            if (this.moc != null && this.moc.getSpaceMoc().getCoverage() < 0.3) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !this.isTransparent();
    }

    private void drawHoles(BufferedImage imgb, ViewSimple v, HealpixKey[] allsky) {
        if (imgb == null) {
            return;
        }
        if (!this.mustDrawHoles(v)) {
            return;
        }
        long t0 = System.currentTimeMillis();
        int vide = 0xFFFFFF & this.getColorHoles().getRGB();
        int[] pixelsRGB = ((DataBufferInt)imgb.getRaster().getDataBuffer()).getData();
        int width = imgb.getWidth();
        int height = imgb.getHeight();
        Projection proj = v.getProj();
        Coord c = new Coord();
        int orderAllSky = (int)CDSHealpix.log2(64L);
        int orderPix = orderAllSky + 3;
        int offset = 0;
        int nb = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int rgb = pixelsRGB[offset];
                if ((0xFFFFFF & rgb) == vide) {
                    Point p = v.getPosition(x, y);
                    c.x = p.x;
                    c.y = p.y;
                    proj.getCoord(c);
                    c = Localisation.frameToFrame(c, 0, this.frameOrigin);
                    if (!Double.isNaN(c.al)) {
                        try {
                            HealpixKey h1;
                            double[] polar = CDSHealpix.radecToPolar(new double[]{c.al, c.del});
                            long npixPixel = CDSHealpix.ang2pix_nest(orderPix, polar[0], polar[1]);
                            long npixFile = npixPixel >>> (orderAllSky << 1);
                            if (!this.isOutMoc(3, npixFile) && (h1 = allsky[(int)npixFile]) != null) {
                                ++nb;
                                int pix = this.color ? h1.getPixelRGB(npixPixel) : this.cm.getRGB(h1.getPixelByte(npixPixel));
                                if (Aladin.levelTrace >= 4) {
                                    pix |= 0xFFFF00FF;
                                }
                                pixelsRGB[offset] = pix;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++x;
                ++offset;
            }
        }
        if (nb > 0) {
            imgb.setRGB(0, 0, width, height, pixelsRGB, 0, width);
        }
        long t1 = System.currentTimeMillis();
        Aladin.trace(4, "drawHoles in " + (t1 - t0) + "ms redrawnPixel: " + nb + "/" + offset);
    }

    protected void getCurrentBufPixels(PlanImage pi, RectangleD rcrop, double zoom, double resMult, boolean fullRes) {
        int order;
        int w = (int)Math.round(rcrop.width * zoom);
        int h = (int)Math.round(rcrop.height * zoom);
        int bitpix = this.getBitpix() == -64 ? -64 : -32;
        int npix = Math.abs(bitpix) / 8;
        byte[] pixelsOrigin = new byte[w * h * npix];
        byte[] onePixelOrigin = new byte[npix];
        double blank = Double.NaN;
        boolean flagClosest = false;
        boolean testClosest = false;
        int n = order = fullRes ? this.maxOrder : (int)((double)this.getOrder() * resMult);
        if (order < 3) {
            order = 3;
        } else if (order > this.maxOrder) {
            order = this.maxOrder;
        }
        int offset = 0;
        double fct = 100.0 / (double)h;
        Coord coo = new Coord();
        Coord coo1 = new Coord();
        block0: for (int y = h - 1; y >= 0; --y) {
            pi.pourcent += fct;
            for (int x = 0; x < w; ++x) {
                double val;
                double x1 = rcrop.x + ((double)x + 0.5) / zoom;
                double y1 = rcrop.y + (double)y / zoom;
                coo.x = x1;
                coo.y = y1;
                pi.projd.getCoord(coo);
                coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
                double x2 = rcrop.x + (double)(x + 1) / zoom;
                double y2 = rcrop.y + (double)y / zoom;
                coo1.x = x2;
                coo1.y = y2;
                pi.projd.getCoord(coo1);
                coo1 = Localisation.frameToFrame(coo1, 0, this.frameOrigin);
                if (!testClosest) {
                    double resSrc;
                    testClosest = true;
                    double resDest = Coo.distance(coo.al, coo.del, coo1.al, coo1.del) * 2.0;
                    if (resDest < (resSrc = this.getPixelResolution()) / 2.0) {
                        flagClosest = true;
                    }
                }
                if (Double.isNaN(val = Double.isNaN(coo.al) || Double.isNaN(coo.del) ? Double.NaN : (flagClosest ? this.getHealpixClosestPixel(coo1.al, coo1.del, order) : this.getHealpixLinearPixel(coo.al, coo.del, coo1.al, coo1.del, order)))) {
                    PlanBG.setPixVal(onePixelOrigin, bitpix, 0, blank);
                    if (!pi.isBlank) {
                        pi.isBlank = true;
                        pi.blank = blank;
                        if (bitpix > 0 && pi.headerFits != null) {
                            pi.headerFits.setKeyValue("BLANK", blank + "");
                        }
                    }
                } else {
                    val = val * this.bScale + this.bZero;
                    PlanBG.setPixVal(onePixelOrigin, bitpix, 0, val);
                }
                System.arraycopy(onePixelOrigin, 0, pixelsOrigin, offset, npix);
                if ((offset += npix) > pixelsOrigin.length) continue block0;
            }
        }
        pi.bitpix = bitpix;
        pi.pixelsOrigin = pixelsOrigin;
        pi.dataMin = this.dataMin * this.bScale + this.bZero;
        pi.dataMax = this.dataMax * this.bScale + this.bZero;
        pi.pixelMin = this.pixelMin * this.bScale + this.bZero;
        pi.pixelMax = this.pixelMax * this.bScale + this.bZero;
        pi.bScale = 1.0;
        pi.bZero = 0.0;
        pi.pixels = this.getPix8Bits(null, pi.pixelsOrigin, pi.bitpix, pi.width, pi.height, pi.pixelMin, pi.pixelMax, false, 0, 0, 0);
        PlanImage.invImageLine(pi.width, pi.height, pi.pixels);
        pi.colorBackground = Color.white;
    }

    protected void getCurrentBufPixels(PlanImage pi, RectangleD rcrop, STCObj stcObj, double zoom, double resMult, boolean fullRes) {
        int order;
        int w = (int)Math.round(rcrop.width * zoom);
        int h = (int)Math.round(rcrop.height * zoom);
        int bitpix = this.getBitpix() == -64 ? -64 : -32;
        int npix = Math.abs(bitpix) / 8;
        byte[] pixelsOrigin = new byte[w * h * npix];
        byte[] onePixelOrigin = new byte[npix];
        double blank = Double.NaN;
        boolean flagClosest = false;
        boolean testClosest = false;
        int n = order = fullRes ? this.maxOrder : (int)((double)this.getOrder() * resMult);
        if (order < 3) {
            order = 3;
        } else if (order > this.maxOrder) {
            order = this.maxOrder;
        }
        int offset = 0;
        double fct = 100.0 / (double)h;
        Coord coo = new Coord();
        Coord coo1 = new Coord();
        Healpix healPix = new Healpix();
        SMoc posBounds = null;
        try {
            if (stcObj != null) {
                posBounds = new SMoc(Aladin.createMocRegion(stcObj, -1, true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        block4: for (int y = h - 1; y >= 0; --y) {
            pi.pourcent += fct;
            for (int x = 0; x < w; ++x) {
                double val = Double.NaN;
                try {
                    double x1 = rcrop.x + ((double)x + 0.5) / zoom;
                    double y1 = rcrop.y + (double)y / zoom;
                    coo.x = x1;
                    coo.y = y1;
                    pi.projd.getCoord(coo);
                    coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
                    double x2 = rcrop.x + (double)(x + 1) / zoom;
                    double y2 = rcrop.y + (double)y / zoom;
                    coo1.x = x2;
                    coo1.y = y2;
                    pi.projd.getCoord(coo1);
                    coo1 = Localisation.frameToFrame(coo1, 0, this.frameOrigin);
                    if (posBounds != null && !posBounds.contains(healPix, coo1.al, coo1.del)) {
                        val = Double.NaN;
                    } else {
                        if (!testClosest) {
                            double resSrc;
                            testClosest = true;
                            double resDest = Coo.distance(coo.al, coo.del, coo1.al, coo1.del) * 2.0;
                            if (resDest < (resSrc = this.getPixelResolution()) / 2.0) {
                                flagClosest = true;
                            }
                        }
                        val = Double.isNaN(coo.al) || Double.isNaN(coo.del) ? Double.NaN : (flagClosest ? this.getHealpixClosestPixel(coo1.al, coo1.del, order) : this.getHealpixLinearPixel(coo.al, coo.del, coo1.al, coo1.del, order));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (Double.isNaN(val)) {
                    PlanBG.setPixVal(onePixelOrigin, bitpix, 0, blank);
                    if (!pi.isBlank) {
                        pi.isBlank = true;
                        pi.blank = blank;
                        if (bitpix > 0 && pi.headerFits != null) {
                            pi.headerFits.setKeyValue("BLANK", blank + "");
                        }
                    }
                } else {
                    val = val * this.bScale + this.bZero;
                    PlanBG.setPixVal(onePixelOrigin, bitpix, 0, val);
                }
                System.arraycopy(onePixelOrigin, 0, pixelsOrigin, offset, npix);
                if ((offset += npix) > pixelsOrigin.length) continue block4;
            }
        }
        pi.bitpix = bitpix;
        pi.pixelsOrigin = pixelsOrigin;
        pi.dataMin = this.dataMin * this.bScale + this.bZero;
        pi.dataMax = this.dataMax * this.bScale + this.bZero;
        pi.pixelMin = this.pixelMin * this.bScale + this.bZero;
        pi.pixelMax = this.pixelMax * this.bScale + this.bZero;
        pi.bScale = 1.0;
        pi.bZero = 0.0;
        pi.pixels = this.getPix8Bits(null, pi.pixelsOrigin, pi.bitpix, pi.width, pi.height, pi.pixelMin, pi.pixelMax, false, 0, 0, 0);
        PlanImage.invImageLine(pi.width, pi.height, pi.pixels);
        pi.colorBackground = Color.white;
    }

    protected void getCurrentBufPixelsBubbleWrapped(PlanImage pi, RectangleD rcrop, STCObj stcObj, double zoom, double resMult, boolean fullRes) {
        int order;
        int w = (int)Math.round(rcrop.width * zoom);
        int h = (int)Math.round(rcrop.height * zoom);
        int bitpix = this.getBitpix() == -64 ? -64 : -32;
        int npix = Math.abs(bitpix) / 8;
        try {
            this.aladin.askIMResourceCheck(w * h * npix);
        }
        catch (Exception e1) {
            Aladin.trace(3, "No sufficient memory");
            this.aladin.notifyIMStatusChange((short)0);
            return;
        }
        SoftReference<byte[]> ref = new SoftReference<byte[]>(new byte[w * h * npix]);
        if (ref == null || ref.get() == null) {
            this.aladin.notifyIMStatusChange((short)-1);
            Aladin.trace(3, "can't process this");
            return;
        }
        this.aladin.notifyIMStatusChange((short)1);
        byte[] onePixelOrigin = new byte[npix];
        double blank = Double.NaN;
        boolean flagClosest = false;
        boolean testClosest = false;
        int n = order = fullRes ? this.maxOrder : (int)((double)this.getOrder() * resMult);
        if (order < 3) {
            order = 3;
        } else if (order > this.maxOrder) {
            order = this.maxOrder;
        }
        int offset = 0;
        double fct = 100.0 / (double)h;
        Coord coo = new Coord();
        Coord coo1 = new Coord();
        Healpix healPix = new Healpix();
        SMoc posBounds = null;
        try {
            if (stcObj != null) {
                posBounds = new SMoc(Aladin.createMocRegion(stcObj, -1, true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        block6: for (int y = h - 1; y >= 0; --y) {
            pi.pourcent += fct;
            for (int x = 0; x < w; ++x) {
                double val = Double.NaN;
                try {
                    double x1 = rcrop.x + ((double)x + 0.5) / zoom;
                    double y1 = rcrop.y + (double)y / zoom;
                    coo.x = x1;
                    coo.y = y1;
                    pi.projd.getCoord(coo);
                    coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
                    double x2 = rcrop.x + (double)(x + 1) / zoom;
                    double y2 = rcrop.y + (double)y / zoom;
                    coo1.x = x2;
                    coo1.y = y2;
                    pi.projd.getCoord(coo1);
                    coo1 = Localisation.frameToFrame(coo1, 0, this.frameOrigin);
                    if (posBounds != null && !posBounds.contains(healPix, coo1.al, coo1.del)) {
                        val = Double.NaN;
                    } else {
                        if (!testClosest) {
                            double resSrc;
                            testClosest = true;
                            double resDest = Coo.distance(coo.al, coo.del, coo1.al, coo1.del) * 2.0;
                            if (resDest < (resSrc = this.getPixelResolution()) / 2.0) {
                                flagClosest = true;
                            }
                        }
                        val = Double.isNaN(coo.al) || Double.isNaN(coo.del) ? Double.NaN : (flagClosest ? this.getHealpixClosestPixel(coo1.al, coo1.del, order) : this.getHealpixLinearPixel(coo.al, coo.del, coo1.al, coo1.del, order));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (Double.isNaN(val)) {
                    PlanBG.setPixVal(onePixelOrigin, bitpix, 0, blank);
                    if (!pi.isBlank) {
                        pi.isBlank = true;
                        pi.blank = blank;
                        if (bitpix > 0 && pi.headerFits != null) {
                            pi.headerFits.setKeyValue("BLANK", blank + "");
                        }
                    }
                } else {
                    val = val * this.bScale + this.bZero;
                    PlanBG.setPixVal(onePixelOrigin, bitpix, 0, val);
                }
                int length = -1;
                if (ref == null || ref.get() == null) {
                    Aladin.trace(3, "ooo im thinking out of memory. free:" + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + " request: " + stcObj);
                    return;
                }
                length = ref.get().length;
                System.arraycopy(onePixelOrigin, 0, ref.get(), offset, npix);
                if ((offset += npix) > length) continue block6;
            }
        }
        pi.bitpix = bitpix;
        if (ref == null || ref.get() == null) {
            Aladin.trace(3, "ooo im thinking out of memory. free:" + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + " request: " + stcObj);
            return;
        }
        pi.pixelsOrigin = ref.get();
        pi.dataMin = this.dataMin * this.bScale + this.bZero;
        pi.dataMax = this.dataMax * this.bScale + this.bZero;
        pi.pixelMin = this.pixelMin * this.bScale + this.bZero;
        pi.pixelMax = this.pixelMax * this.bScale + this.bZero;
        pi.bScale = 1.0;
        pi.bZero = 0.0;
        pi.pixels = this.getPix8Bits(null, pi.pixelsOrigin, pi.bitpix, pi.width, pi.height, pi.pixelMin, pi.pixelMax, false, 0, 0, 0);
        PlanImage.invImageLine(pi.width, pi.height, pi.pixels);
        pi.colorBackground = Color.white;
    }

    protected byte[] getBufPixels8(ViewSimple v) {
        return this.getPixels8Area(v, new RectangleD(0.0, 0.0, v.rv.width, v.rv.height), true);
    }

    protected byte[] getPixels8Area(ViewSimple v, RectangleD rcrop, boolean now) {
        int[] rgb = this.getPixelsRGBArea(v, rcrop, now);
        if (rgb == null) {
            return null;
        }
        int taille = rgb.length;
        byte[] pixels = new byte[taille];
        for (int i = 0; i < taille; ++i) {
            if ((rgb[i] >>> 24 & 0xFF) == 0) {
                pixels[i] = 0;
                continue;
            }
            int pix = rgb[i] & 0xFF;
            if (pix < 255) {
                ++pix;
            }
            pixels[i] = (byte)(pix & 0xFF);
        }
        rgb = null;
        return pixels;
    }

    protected byte[] getPixels8Area(ViewSimple v, RectangleD rcrop, STCObj stcObj, boolean now) {
        int[] rgb = this.getPixelsRGBArea(v, rcrop, stcObj, now);
        if (rgb == null) {
            return null;
        }
        int taille = rgb.length;
        byte[] pixels = new byte[taille];
        for (int i = 0; i < taille; ++i) {
            if ((rgb[i] >>> 24 & 0xFF) == 0) {
                pixels[i] = 0;
                continue;
            }
            int pix = rgb[i] & 0xFF;
            if (pix < 255) {
                ++pix;
            }
            pixels[i] = (byte)(pix & 0xFF);
        }
        rgb = null;
        return pixels;
    }

    protected int[] getPixelsRGBArea(ViewSimple v, RectangleD rcrop, boolean now) {
        int y;
        if (v == null) {
            return null;
        }
        BufferedImage imgBuf = new BufferedImage(v.rv.width, v.rv.height, 2);
        Graphics g = imgBuf.getGraphics();
        this.drawLosanges(g, v, now, imgBuf);
        g.finalize();
        g = null;
        int width = (int)Math.ceil(rcrop.width);
        int height = (int)Math.ceil(rcrop.height);
        int taille = width * height;
        int[] rgb = new int[taille];
        int x = (int)Math.floor(rcrop.x);
        if (x < 0) {
            x = 0;
        }
        if ((y = (int)Math.floor(rcrop.y)) < 0) {
            y = 0;
        }
        imgBuf.getRGB(x, y, width, height, rgb, 0, width);
        imgBuf.flush();
        imgBuf = null;
        return rgb;
    }

    protected int[] getPixelsRGBArea(ViewSimple v, RectangleD rcrop, STCObj stcObj, boolean now) {
        int y;
        if (v == null) {
            return null;
        }
        BufferedImage imgBuf = new BufferedImage(v.rv.width, v.rv.height, 2);
        Graphics g = imgBuf.getGraphics();
        Shape shape = this.getShape(v, stcObj);
        if (shape != null) {
            g.setClip(shape);
        }
        this.drawLosanges(g, v, now, imgBuf);
        g.finalize();
        if (shape != null) {
            g.setClip(null);
        }
        g = null;
        int width = (int)Math.ceil(rcrop.width);
        int height = (int)Math.ceil(rcrop.height);
        int taille = width * height;
        int[] rgb = new int[taille];
        int x = (int)Math.floor(rcrop.x);
        if (x < 0) {
            x = 0;
        }
        if ((y = (int)Math.floor(rcrop.y)) < 0) {
            y = 0;
        }
        imgBuf.getRGB(x, y, width, height, rgb, 0, width);
        imgBuf.flush();
        imgBuf = null;
        return rgb;
    }

    public Shape getShape(ViewSimple v, STCObj stcObj) {
        Shape shape = null;
        Coord coord = null;
        PointD pt = null;
        if (stcObj instanceof STCCircle) {
            STCCircle circle = (STCCircle)stcObj;
            coord = this.getCoodSetXY(circle.getCenter().al, circle.getCenter().del);
            double radius = Server.getAngleInArcmin(String.valueOf(circle.getRadius()), 8) / 60.0;
            int plotRadius = (int)Math.round(Fov.getPlotRadiusForCircleFromCoord(this.projd, coord, radius) * v.getZoom());
            pt = v.getViewCoordDble(coord.x, coord.y);
            shape = new Ellipse2D.Double((int)(pt.x - (double)plotRadius), (int)(pt.y - (double)plotRadius), plotRadius * 2, plotRadius * 2);
        } else if (stcObj instanceof STCPolygon) {
            STCPolygon poly = (STCPolygon)stcObj;
            ArrayList<Double> xCorners = poly.getxCorners();
            ArrayList<Double> yCorners = poly.getyCorners();
            int[] xPoly = new int[xCorners.size()];
            int[] yPoly = new int[xCorners.size()];
            for (int i = 0; i < xCorners.size(); ++i) {
                coord = this.getCoodSetXY((Double)xCorners.get(i), (Double)yCorners.get(i));
                pt = v.getViewCoordDble(coord.x, coord.y);
                xPoly[i] = (int)Math.floor(pt.x);
                if (xPoly[i] < 0) {
                    xPoly[i] = 0;
                }
                yPoly[i] = (int)Math.floor(pt.y);
                if (yPoly[i] >= 0) continue;
                yPoly[i] = 0;
            }
            shape = new Polygon(xPoly, yPoly, xPoly.length);
        }
        return shape;
    }

    public Coord getCoodSetXY(double ra, double dec) {
        Coord coord = new Coord(ra, dec);
        coord = Localisation.frameToFrame(coord, 0, this.frameOrigin);
        coord = this.projd.getXY(coord);
        return coord;
    }

    @Override
    protected Image getImage(ViewSimple v, boolean now) {
        if (now) {
            BufferedImage img = new BufferedImage(v.rv.width, v.rv.height, 3);
            Graphics g = img.getGraphics();
            this.drawLosanges(g, v, now, img);
            this.adjustCM(img);
            g.dispose();
            return img;
        }
        if (v.imageBG != null && v.ovizBG == v.iz && v.oImgIDBG == this.imgID && v.rv.width == v.owidthBG && v.rv.height == v.oheightBG) {
            return v.imageBG;
        }
        if (v.imageBG == null || v.rv.width != v.owidthBG || v.rv.height != v.oheightBG) {
            if (v.imageBG != null) {
                v.imageBG.flush();
            }
            if (v.g2BG != null) {
                v.g2BG.dispose();
            }
            v.imageBG = new BufferedImage(v.rv.width, v.rv.height, 3);
            v.g2BG = v.imageBG.getGraphics();
        } else {
            ((Graphics2D)v.g2BG).setComposite(AlphaComposite.Clear);
            v.g2BG.fillRect(0, 0, v.rv.width, v.rv.height);
            ((Graphics2D)v.g2BG).setComposite(AlphaComposite.Src);
        }
        v.oImgIDBG = this.imgID;
        v.owidthBG = v.rv.width;
        v.oheightBG = v.rv.height;
        v.ovizBG = v.iz;
        this.flagClearBuf = false;
        if (!this.isTransparent()) {
            this.drawBackground(v.g2BG, v);
        }
        this.drawLosanges(v.g2BG, v, now, v.imageBG);
        try {
            this.adjustCM(v.imageBG);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.w = v.imageBG.getWidth();
            v.h = v.imageBG.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v.imageBG;
    }

    private void adjustCM(BufferedImage img) {
        boolean flagInitRGB;
        if (!this.isColored()) {
            return;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        boolean modif = this.RGBControl[0] != 0 || this.RGBControl[1] != 128 || this.RGBControl[2] != 255 || this.RGBControl[3] != 0 || this.RGBControl[4] != 128 || this.RGBControl[5] != 255 || this.RGBControl[6] != 0 || this.RGBControl[7] != 128 || this.RGBControl[8] != 255 || this.video != 0;
        int size = width * height;
        boolean bl = flagInitRGB = this.lastHistID != this.imgID;
        if (flagInitRGB) {
            this.lastHistID = this.imgID;
            if (this.red == null || size != this.red.length) {
                this.red = new byte[size];
                this.green = new byte[size];
                this.blue = new byte[size];
            }
        }
        if (!flagInitRGB && !modif) {
            return;
        }
        int[] pixelsRGB = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        for (int pos = 0; pos < pixelsRGB.length; ++pos) {
            int rgb = pixelsRGB[pos];
            int a = (rgb & 0xFF000000) >> 24;
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            if (flagInitRGB) {
                this.red[pos] = (byte)(0xFF & r);
                this.green[pos] = (byte)(0xFF & g);
                this.blue[pos] = (byte)(0xFF & b);
            }
            if (!modif) continue;
            r = PlanImageRGB.filter(this.RGBControl[0], this.RGBControl[1], this.RGBControl[2], r & 0xFF);
            g = PlanImageRGB.filter(this.RGBControl[3], this.RGBControl[4], this.RGBControl[5], g & 0xFF);
            b = PlanImageRGB.filter(this.RGBControl[6], this.RGBControl[7], this.RGBControl[8], b & 0xFF);
            if (this.video == 1) {
                r ^= 0xFFFFFFFF;
                g ^= 0xFFFFFFFF;
                b ^= 0xFFFFFFFF;
            }
            pixelsRGB[pos] = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
        if (modif) {
            img.setRGB(0, 0, width, height, pixelsRGB, 0, width);
        }
        if (flagInitRGB) {
            this.resetHist();
            if (this.aladin.frameCM != null) {
                this.aladin.frameCM.repaint();
            }
        }
    }

    protected void filterRGB(int[] triangle, int color) {
        this.changeImgID();
        this.RGBControl[color * 3] = triangle[0];
        this.RGBControl[color * 3 + 1] = triangle[1];
        this.RGBControl[color * 3 + 2] = triangle[2];
    }

    @Override
    protected double[] getHistArray(int rgb) {
        return rgb == 0 ? this.histRed : (rgb == 1 ? this.histGreen : this.histBlue);
    }

    @Override
    protected byte[] getPixelHist(int rgb) {
        return rgb == -1 ? super.getPixelHist(rgb) : (rgb == 0 ? this.red : (rgb == 1 ? this.green : this.blue));
    }

    protected synchronized void redrawAsap() {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                PlanBG.this.changeImgID();
                PlanBG.this.aladin.view.repaintAll();
            }
        };
        this.timer.scheduleAtFixedRate(timerTask, 5L, 5L);
    }

    protected synchronized void stopRedraw() {
        if (this.timer == null) {
            return;
        }
        System.out.println("stopping fading process");
        this.timer.cancel();
        this.timer = null;
        this.op = 0.0f;
    }

    @Override
    protected void draw(Graphics g, ViewSimple v, int dx, int dy, float op) {
        this.draw(g, v, dx, dy, -1.0f, false);
    }

    protected void draw(Graphics g, ViewSimple v, int dx, int dy, float op, boolean now) {
        if (v == null) {
            return;
        }
        if (op == -1.0f) {
            op = this.getOpacityLevel();
        }
        if ((double)op <= 0.1) {
            return;
        }
        this.resetFading();
        if (g instanceof Graphics2D) {
            Composite saveComposite;
            Graphics2D g2d;
            block16: {
                g2d = (Graphics2D)g;
                saveComposite = g2d.getComposite();
                try {
                    if ((double)op < 0.9) {
                        Composite myComposite = cds.tools.Util.getImageComposite(op);
                        g2d.setComposite(myComposite);
                    }
                    if (this.drawMode == 0) {
                        g2d.drawImage(this.getImage(v, now), dx, dy, this.aladin);
                    } else if (this.drawMode == 1) {
                        this.drawPolarisation(g2d, v);
                    }
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block16;
                    e.printStackTrace();
                }
            }
            g2d.setComposite(saveComposite);
        } else if (this.drawMode == 0) {
            g.drawImage(this.getImage(v, now), dx, dy, this.aladin);
        } else if (this.drawMode == 1) {
            this.drawPolarisation(g, v);
        }
        this.setHasMoreDetails(this.maxOrder(v) < this.maxOrder);
        if (this.isFading()) {
            this.redrawAsap();
        } else {
            this.stopRedraw();
        }
        this.readyDone = this.readyAfterDraw;
    }

    protected void drawHealpixMouse(Graphics g, ViewSimple v) {
        try {
            Coord coo = new Coord(this.aladin.localisation.getLastCoord().al, this.aladin.localisation.getLastCoord().del);
            coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
            int norder = this.aladin.getOrder();
            if (norder < 0) {
                return;
            }
            double[] polar = CDSHealpix.radecToPolar(new double[]{coo.al, coo.del});
            long npix = CDSHealpix.ang2pix_nest(norder, polar[0], polar[1]);
            HealpixKey hk = new HealpixKey(this, norder, npix, 0);
            hk.drawCtrl(g, v);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void resetPriority() {
        Enumeration<HealpixKey> e = this.pixList.elements();
        while (e.hasMoreElements()) {
            HealpixKey healpix = e.nextElement();
            if (healpix.npix == -1L || healpix.priority >= 1000) continue;
            healpix.priority += 1000;
        }
        this.priority = 0;
    }

    protected void drawPolarisation(Graphics g, ViewSimple v) {
        long[] pix = null;
        int max = Math.min(this.maxOrder(v), this.maxOrder);
        int nb = 0;
        if (v.getTaille() > 20.0 && (this.hasDrawnSomething = this.drawAllSky(g, v, null))) {
            return;
        }
        this.setMem();
        this.resetPriority();
        int order = Math.max(3, max);
        pix = this.getPixListView(v, order);
        for (int i = 0; i < pix.length; ++i) {
            HealpixKey healpix;
            if (new HealpixKey(this, order, pix[i], 0).isOutView(v) || (healpix = this.getHealpix(order, pix[i], true)) == null) continue;
            healpix.priority = 250 - this.priority++;
            int status = healpix.getStatus();
            if (status == 7) continue;
            if (status == 8) {
                healpix.setStatus(1, true);
            }
            healpix.resetTimer();
            if (status != 6) continue;
            nb += ((HealpixKeyPol)healpix).drawPolarisation(g, v);
        }
        this.hasDrawnSomething = nb > 0;
        this.tryWakeUp();
    }

    protected boolean mustDrawFast() {
        if (!this.computeDrawFast) {
            return this.lastMustDrawFast;
        }
        boolean rep = this.aladin.view.mustDrawFast();
        boolean bl = !rep ? false : (this.lastMustDrawFast = this.statTimeDisplay > 100L);
        if (this.lastMustDrawFast) {
            this.computeDrawFast = false;
        }
        return this.lastMustDrawFast;
    }

    protected void resetDrawFastDetection() {
        this.computeDrawFast = true;
    }

    protected void drawHealpixGrid(Graphics g, ViewSimple v) {
        int i;
        long[] pix;
        int order = Math.max(this.getMinOrder(), Math.min(this.maxOrder(v), this.maxOrder));
        if (v.isAllSky()) {
            pix = new long[12 * (int)CDSHealpix.pow2(order) * (int)CDSHealpix.pow2(order)];
            for (i = 0; i < pix.length; ++i) {
                pix[i] = i;
            }
        } else {
            pix = this.getPixList(v, this.getCooCentre(v), order);
        }
        for (i = 0; i < pix.length; ++i) {
            HealpixKey healpix = new HealpixKey(this, order, pix[i], 0);
            if (this.isOutMoc(order, pix[i]) || healpix.isOutView(v)) continue;
            try {
                healpix.drawLosangeBorder(g, v, null, null, null);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void drawLosangesNow(Graphics g, ViewSimple v, BufferedImage imgb) {
        block14: {
            int i;
            long[] pix;
            int order = Math.max(this.getMinOrder(), Math.min(this.maxOrder(v), this.maxOrder));
            boolean lowResolution = v.isAllSky() && order == this.getMinOrder();
            HealpixKey allsky = this.pixList.get(this.key(this.getMinOrder(), -1L));
            if (lowResolution && allsky == null) {
                allsky = new HealpixAllsky(this, this.getMinOrder());
                try {
                    allsky.loadNow();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (v.isAllSky()) {
                pix = new long[12 * (int)CDSHealpix.pow2(order) * (int)CDSHealpix.pow2(order)];
                for (i = 0; i < pix.length; ++i) {
                    pix[i] = i;
                }
            } else {
                pix = this.getPixList(v, this.getCooCentre(v), order);
            }
            for (i = 0; i < pix.length; ++i) {
                HealpixKey healpix;
                if (this.isOutMoc(order, pix[i]) || new HealpixKey(this, order, pix[i], 0).isOutView(v)) continue;
                if (lowResolution && allsky != null) {
                    healpix = allsky.getPixList()[i];
                } else {
                    healpix = this.getHealpix(order, pix[i], true);
                    try {
                        healpix.loadNow();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                if (healpix.getStatus() != 6) continue;
                healpix.resetTimer();
                healpix.draw(g, v);
            }
            if (Aladin.TESTV12) {
                try {
                    this.drawHoles(imgb, v, allsky.getPixList());
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block14;
                    e.printStackTrace();
                }
            }
        }
    }

    protected synchronized void drawLosanges(Graphics g, ViewSimple v, boolean now, BufferedImage imgb) {
        if (now) {
            this.drawLosangesNow(g, v, imgb);
        } else {
            this.drawLosangesAsync(g, v, imgb);
        }
    }

    protected boolean isOutMoc(int order, long npix) {
        int frameMoc;
        if (this.moc == null) {
            return false;
        }
        char a = this.moc.getSpaceSys().charAt(0);
        int n = a == 'G' ? 3 : (frameMoc = a == 'E' ? 2 : 0);
        if (this.frameOrigin != frameMoc) {
            return false;
        }
        boolean res = !this.moc.isIntersecting(order, npix);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawLosangesAsync(Graphics g, ViewSimple v, BufferedImage imgb) {
        HealpixKey allsky;
        this.allWaitingKeysDrawn = false;
        boolean first = true;
        long t1 = cds.tools.Util.getTime(0);
        int nb = 0;
        long[] pix = null;
        int z = (int)this.getZ(v);
        int min = Math.max(this.getMinOrder(), this.minOrder);
        int max = Math.min(this.maxOrder(v), this.maxOrder);
        boolean allKeyReady = false;
        boolean oneKeyReady = false;
        boolean allskyDrawn = false;
        HealpixKey healpixKey = allsky = this.isDynHiPS() ? null : this.pixList.get(this.key(this.getMinOrder(), -1L, z));
        if (this.isDynHiPS()) {
            min = 3;
        }
        if (min < this.getMinOrder()) {
            if (this.drawAllSky(g, v, imgb)) {
                ++nb;
            }
            allskyDrawn = true;
        } else {
            int cmin;
            boolean fast = this.mustDrawFast();
            if (fast) {
                min = max;
            }
            double theta = 0.0;
            double phi = 0.0;
            Coord center = this.getCooCentre(v);
            if (center != null) {
                theta = 1.5707963267948966 - Math.toRadians(center.del);
                phi = Math.toRadians(center.al);
            }
            allKeyReady = true;
            if (max < this.getMinOrder()) {
                allKeyReady = false;
            } else {
                pix = this.getPixList(v, center, max);
                for (int i = 0; i < pix.length; ++i) {
                    HealpixKey healpix = this.getHealpix(max, pix[i], z, false);
                    if (healpix == null) {
                        if (this.isOutMoc(max, pix[i]) || new HealpixKey(this, max, pix[i], 0).isOutView(v)) {
                            pix[i] = -1L;
                            continue;
                        }
                        allKeyReady = false;
                        break;
                    }
                    if (this.isOutMoc(max, pix[i]) || healpix.isOutView(v)) {
                        pix[i] = -1L;
                        continue;
                    }
                    int status = healpix.getStatus();
                    if (status != 6 && status != 7) {
                        allKeyReady = false;
                        break;
                    }
                    healpix.resetTimer();
                    oneKeyReady = true;
                }
            }
            if (nb == 0 && max <= this.getMinOrder() && (!allKeyReady || !oneKeyReady && allsky != null)) {
                if (this.drawAllSky(g, v, imgb)) {
                    ++nb;
                }
                allskyDrawn = true;
            }
            this.resetPriority();
            HealpixKey healpix = null;
            int n = min < max && allKeyReady ? max : (cmin = min < max - 3 ? max - 3 : min);
            if (this.aladin.isAnimated() && cmin < max - 1) {
                cmin = max - 1;
                oneKeyReady = true;
            }
            Image imgPost = null;
            Object gImgPost = null;
            Object oanc = null;
            int n1 = 0;
            if (max >= this.getMinOrder()) {
                for (int order = cmin; (order <= max || !oneKeyReady && order <= max + 2 && order <= this.maxOrder) && (pix = this.getPixList(v, center, order)).length != 0; ++order) {
                    block36: {
                        nDraw1 += pix.length;
                        try {
                            if (center == null) break block36;
                            long firstPix = CDSHealpix.ang2pix_nest(order, theta, phi);
                            for (int i = 0; i < pix.length; ++i) {
                                if (pix[i] != firstPix) continue;
                                long a = pix[0];
                                pix[0] = pix[i];
                                pix[i] = a;
                                break;
                            }
                        }
                        catch (Exception firstPix) {
                            // empty catch block
                        }
                    }
                    for (int i = 0; i < pix.length; ++i) {
                        int n2;
                        HealpixKey testIn;
                        if (pix[i] == -1L) continue;
                        healpix = this.getHealpix(order, pix[i], z, false);
                        HealpixKey healpixKey2 = testIn = healpix != null ? healpix : new HealpixKey(this, order, pix[i], 0);
                        if (!allKeyReady && (this.isOutMoc(order, pix[i]) || testIn.isOutView(v))) {
                            ++nOut1;
                            pix[i] = -1L;
                            continue;
                        }
                        if (healpix == null && order <= max) {
                            healpix = this.getHealpix(order, pix[i], z, true);
                        }
                        if (healpix == null) continue;
                        if (order < max) {
                            n2 = 500 - this.priority++;
                        } else {
                            int n3 = this.priority;
                            n2 = n3;
                            this.priority = n3 + 1;
                        }
                        healpix.priority = n2;
                        int status = healpix.getStatus();
                        if (status == 7) continue;
                        if (status == 8) {
                            healpix.setStatus(1, true);
                        }
                        healpix.resetTimer();
                        if (status != 6) {
                            HealpixKey h = this.getHealpixPreviousFrame(order, pix[i]);
                            if (h == null) continue;
                            nb += h.draw(g, v);
                            continue;
                        }
                        Graphics g1 = g;
                        nb += healpix.draw(g1, v);
                        this.setHealpixPreviousFrame(order, pix[i]);
                        if (!first || this.isColored()) continue;
                        first = false;
                        this.pixels = healpix.pixels;
                        this.pixelsOrigin = healpix.pixelsOrigin;
                        this.resetHist();
                    }
                }
            }
            if (imgPost != null) {
                System.err.println("imgPost drawn n1=" + n1 + " op=" + this.op);
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = null;
                try {
                    saveComposite = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, this.op));
                    g2.drawImage(imgPost, 0, 0, null);
                    this.updateFading(true);
                }
                finally {
                    if (saveComposite != null) {
                        g2.setComposite(saveComposite);
                    }
                }
            }
            boolean bl = this.allWaitingKeysDrawn = allKeyReady || max <= this.getMinOrder() && this.hasDrawnSomething;
        }
        if (this.isPause() && nb == 0 && !allskyDrawn && allsky != null && allsky.getStatus() == 6 && this.drawAllSky(g, v, imgb)) {
            ++nb;
        }
        this.hasDrawnSomething = nb > 0;
        this.tryWakeUp();
        long t2 = cds.tools.Util.getTime(0);
        long l = (t2 - t1) / 1000000L;
        this.statTimeDisplayArray[this.nStat++] = l;
        long statTime = l;
        if (this.nStat == this.statTimeDisplayArray.length) {
            this.nStat = 0;
        }
        long totalStatTime = 0L;
        int nbStat = 0;
        for (int i = 0; i < this.statTimeDisplayArray.length; ++i) {
            if (this.statTimeDisplayArray[i] == 0L) continue;
            totalStatTime += this.statTimeDisplayArray[i];
            ++nbStat;
        }
        this.statTimeDisplay = nbStat > 0 ? totalStatTime / (long)nbStat : -1L;
        this.statNbItems = nb;
    }

    protected HealpixKey getHealpixPreviousFrame(int order, long npix) {
        return null;
    }

    protected void setHealpixPreviousFrame(int order, long npix) {
    }

    protected double getFps() {
        return this.mustDrawFast() ? 0.0 : (this.statTimeDisplay > 0L ? 1000.0 / (double)this.statTimeDisplay : -1.0);
    }

    private synchronized boolean isFading() {
        return this.fading;
    }

    protected synchronized void resetFading() {
        this.fading = false;
    }

    protected synchronized void updateFading(boolean flag) {
        this.fading |= flag;
    }

    protected void askForRepaint() {
        this.changeImgID();
        if (this.aladin.view == null) {
            return;
        }
        if (this.first) {
            this.first = false;
            this.aladin.view.setRepere(this);
        }
        this.aladin.view.repaintAll();
    }

    protected void drawForeground(Graphics gv, ViewSimple v) {
        this.drawForeground1(gv, v);
        if (this.flagWaitAllSky && this.drawMode == 0 && this.getMinOrder() == 3) {
            gv.setColor(Color.red);
            gv.drawString("Whole sky in progress...", 5, 30);
        }
    }

    private void drawForeground1(Graphics gv, ViewSimple v) {
        v = v.getProjSyncView();
        if (this.aladin.calque.hasHpxGrid() || this.isOverlay()) {
            if (this.aladin.calque.hasHpxGrid()) {
                this.drawHealpixGrid(gv, v);
            }
            return;
        }
        Graphics2D g = (Graphics2D)gv;
        int x = 0;
        int y = 0;
        int rayon = 0;
        int grandAxe = 0;
        double angle = 0.0;
        if (v.getTaille() < 15.0) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color bckCol = v.getCouleurFond();
        g.setColor(bckCol);
        Stroke st = g.getStroke();
        int epaisseur = this.projd.t == 7 || this.projd.t == 17 ? 20 : 100;
        g.setStroke(new BasicStroke(epaisseur));
        Projection projd = v.getProj().copy();
        projd.setProjCenter(0.0, 0.0);
        projd.frame = 0;
        rayon = 0;
        int m = epaisseur / 2;
        int chouilla = 1;
        if (projd.t == 1 || projd.t == 3 || projd.t == 5) {
            Coord c = projd.c.getProjCenter();
            projd.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            c.del = c.del + signe * (double)(projd.t == 1 ? 89 : 179);
            projd.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            double deltaY = haut.y - center.y;
            double deltaX = haut.x - center.x;
            rayon = (int)Math.abs(Math.sqrt(deltaX * deltaX + deltaY * deltaY)) - chouilla;
            x = (int)(center.x - (double)rayon);
            y = (int)(center.y - (double)rayon);
            g.drawOval(x - m, y - m, (rayon + m) * 2, (rayon + m) * 2);
        } else if (projd.t == 4 || projd.t == 11) {
            Projection p = projd.copy();
            angle = -p.c.getProjRot();
            p.setProjRot(0.0);
            p.frame = 0;
            p.setProjCenter(0.0, 0.1);
            Coord c = p.c.getProjCenter();
            p.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            double del = c.del;
            c.del += signe * 89.0;
            p.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            c.del = del;
            c.al += 179.0;
            p.getXYNative(c);
            PointD droit = v.getViewCoordDble(c.x, c.y);
            rayon = (int)Math.abs(haut.y - center.y) - chouilla;
            grandAxe = (int)Math.abs(droit.x - center.x) - chouilla;
            x = (int)(center.x - (double)grandAxe);
            y = (int)(center.y - (double)rayon);
            if (angle == 0.0) {
                g.drawOval(x - m, y - m, (grandAxe + m) * 2, (rayon + m) * 2);
            } else {
                cds.tools.Util.drawEllipse(g, x + grandAxe, y + rayon, grandAxe + m, rayon + m, angle);
            }
        } else if (projd.t == 7) {
            projd = v.getProjSyncView().getProj();
            Coord c1 = new Coord(1.0, 89.0);
            projd.getXYNative(c1);
            Point p1 = v.getViewCoord(c1.x, c1.y);
            Coord c2 = new Coord(359.0, -89.0);
            projd.getXYNative(c2);
            Point p2 = v.getViewCoord(c2.x, c2.y);
            x = p1.x;
            y = p1.y;
            int w = p2.x - p1.x;
            int h = p2.y - p1.y;
            g.drawRect(x, y, w, h);
        } else if (projd.t == 17) {
            Projection p = projd.copy();
            p.setProjCenter(0.0, 0.0);
            Coord c = p.c.getProjCenter();
            p.getXY(c);
            Point center = v.getViewCoord(c.x, c.y);
            c.al += 180.0;
            p.getXY(c);
            Point gauche = v.getViewCoord(c.x, c.y);
            x = gauche.x;
            y = 0;
            int w = 2 * (center.x - gauche.x);
            int h = v.rv.height;
            g.drawLine(x, 0, x, h);
            g.drawLine(x + w, 0, x + w, h);
        }
        g.setStroke(st);
        if (this.pixMode != 0 && this.pixMode != 1 && this.video == 1) {
            m = 0;
            g.setStroke(new BasicStroke(2.0f));
            if (projd.t == 1 || projd.t == 3 || projd.t == 5) {
                g.drawOval(x - m, y - m, (rayon + m) * 2, (rayon + m) * 2);
            } else if (projd.t == 4 || projd.t == 11) {
                if (angle == 0.0) {
                    g.drawOval(x - m, y - m, (grandAxe + m) * 2, (rayon + m) * 2);
                } else {
                    cds.tools.Util.drawEllipse(g, x + grandAxe, y + rayon, grandAxe + m, rayon + m, angle);
                }
            }
            g.setStroke(st);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private Color getColorHoles() {
        int b;
        int g;
        int r;
        if (this.isTransparent()) {
            r = 69;
            g = 145;
            b = 161;
        } else if (this.color) {
            b = 0;
            g = 0;
            r = 0;
        } else if (this.cm == null) {
            b = 255;
            g = 255;
            r = 255;
        } else {
            r = this.cm.getRed(0);
            g = this.cm.getGreen(0);
            b = this.cm.getBlue(0);
        }
        if (Aladin.TESTV12) {
            b = b == 255 ? --b : ++b;
        }
        return new Color(r, g, b);
    }

    protected void drawBackground(Graphics g, ViewSimple v) {
        if (this.aladin.calque.hasHpxGrid() || this.isOverlay()) {
            return;
        }
        Projection projd = v.getProjSyncView().getProj().copy();
        projd.setProjCenter(0.0, 0.0);
        projd.frame = 0;
        int x = 0;
        int y = 0;
        int rayon = 0;
        int grandAxe = 0;
        double angle = 0.0;
        Color bckCol = this.getColorHoles();
        g.setColor(bckCol);
        rayon = 0;
        boolean isTransparent = this.isTransparent();
        if (projd.t == 1 || projd.t == 3 || projd.t == 5) {
            Coord c = projd.c.getProjCenter();
            projd.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            c.del = c.del + signe * (double)(projd.t == 1 ? 89 : 179);
            projd.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            double deltaY = haut.y - center.y;
            double deltaX = haut.x - center.x;
            rayon = (int)Math.abs(Math.sqrt(deltaX * deltaX + deltaY * deltaY));
            x = (int)(center.x - (double)rayon);
            y = (int)(center.y - (double)rayon);
            if (isTransparent) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(x, y, new Color(0, 0, 70), x + rayon * 2, y + rayon * 2, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                g.fillOval(x, y, rayon * 2, rayon * 2);
                g2d.setPaint(paint);
            } else {
                g.fillOval(x, y, rayon * 2, rayon * 2);
            }
        } else if (projd.t == 4 || projd.t == 11) {
            Projection p = projd.copy();
            angle = -p.c.getProjRot();
            p.setProjRot(0.0);
            p.frame = 0;
            p.setProjCenter(0.0, 0.1);
            Coord c = p.c.getProjCenter();
            p.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            double del = c.del;
            c.del += signe * 89.0;
            p.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            c.del = del;
            c.al += 179.0;
            p.getXYNative(c);
            PointD droit = v.getViewCoordDble(c.x, c.y);
            rayon = (int)Math.abs(haut.y - center.y);
            grandAxe = (int)Math.abs(droit.x - center.x);
            x = (int)(center.x - (double)grandAxe);
            y = (int)(center.y - (double)rayon);
            if (isTransparent) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(x + rayon / 4, y + rayon / 4, new Color(0, 0, 70), x + grandAxe * 2 - rayon / 4, y + rayon * 2 - rayon / 4, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                if (angle == 0.0) {
                    g.fillOval(x, y, grandAxe * 2, rayon * 2);
                } else {
                    cds.tools.Util.fillEllipse(g, x + grandAxe, y + rayon, grandAxe, rayon, angle);
                }
                g2d.setPaint(paint);
            } else if (angle == 0.0) {
                g.fillOval(x, y, grandAxe * 2, rayon * 2);
            } else {
                cds.tools.Util.fillEllipse(g, x + grandAxe, y + rayon, grandAxe, rayon, angle);
            }
        } else if (projd.t == 7) {
            projd = v.getProjSyncView().getProj();
            Coord c1 = new Coord(1.0, 89.0);
            projd.getXYNative(c1);
            Point p1 = v.getViewCoord(c1.x, c1.y);
            Coord c2 = new Coord(359.0, -89.0);
            projd.getXYNative(c2);
            Point p2 = v.getViewCoord(c2.x, c2.y);
            x = p1.x;
            y = p1.y;
            int w = p2.x - p1.x;
            int h = p2.y - p1.y;
            if (isTransparent) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 70), w, h, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                g.fillRect(x, y, w, h);
                g2d.setPaint(paint);
            } else {
                g.fillRect(x, y, w, h);
            }
        } else if (projd.t == 17) {
            Projection p = projd.copy();
            p.setProjCenter(0.0, 0.0);
            Coord c = p.c.getProjCenter();
            p.getXYNative(c);
            Point center = v.getViewCoord(c.x, c.y);
            c.al += 180.0;
            p.getXYNative(c);
            Point gauche = v.getViewCoord(c.x, c.y);
            x = gauche.x;
            y = 0;
            int w = 2 * (center.x - gauche.x);
            int h = v.rv.height;
            if (isTransparent) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 70), w, h, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                g.fillRect(x, y, w, h);
                g2d.setPaint(paint);
            } else {
                g.fillRect(x, y, w, h);
            }
        } else {
            int w = v.rv.width;
            int h = v.rv.height;
            if (isTransparent) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 70), w, h, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                g.fillRect(0, 0, w, h);
                g2d.setPaint(paint);
            } else {
                g.fillRect(0, 0, w, h);
            }
        }
    }

    protected boolean isSegmentIAUConv() {
        return this.segmentIAUConv;
    }

    protected float getSegmentLenFactor() {
        return this.segmentLenFactor;
    }

    protected void setSegmentLenFactor(float segmentLenFactor) {
        this.segmentLenFactor = segmentLenFactor;
    }

    protected int getSegmentThickness() {
        return this.segmentThickness;
    }

    protected void setSegmentThickness(int segmentThickness) {
        this.segmentThickness = segmentThickness;
    }

    protected float getSegmentDensityFactor() {
        return this.segmentDensityFactor;
    }

    protected void setSegmentDensityFactor(float segmentDensityFactor) {
        this.segmentDensityFactor = segmentDensityFactor;
    }

    private void shouldRefresh() {
        long t = System.currentTimeMillis();
        if (t - this.timerLastDrawBG < 500L) {
            return;
        }
        this.timerLastDrawBG = t;
        this.changeImgID();
        this.aladin.view.repaintAll();
    }

    protected boolean detectServerError(int[] nb) {
        if (this.moc == null) {
            return false;
        }
        this.removeHealpixOutsideMoc();
        int nbReady = 0;
        int nbError = 0;
        for (HealpixKey key : this.pixList.values()) {
            int status = key.getStatus();
            if (status == 6) {
                ++nbReady;
                continue;
            }
            if (status != 7) continue;
            ++nbError;
        }
        return nbReady == 0 && nbError > 5;
    }

    public String testnet() throws Exception {
        try {
            if (this.moc == null) {
                this.loadInternalMoc();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long time = 0L;
        long tileTime = 0L;
        long allskyTime = 0L;
        long size = 0L;
        int minOrder = 3;
        long timeMax = 10000L;
        long start = System.currentTimeMillis();
        this.resetGzippedMode();
        System.out.println("Testnet HiPS " + this.label + " maxOrder=" + this.maxOrder + " from " + this.url + " :");
        int n = 0;
        boolean allsky = false;
        int memo = Aladin.levelTrace;
        Aladin.levelTrace = 0;
        block4: while (true) {
            try {
                while (true) {
                    HealpixKey hk;
                    if (System.currentTimeMillis() - start > timeMax) {
                        if (allsky) break block4;
                        allsky = true;
                    }
                    int order = minOrder + (int)(Math.random() * (double)(this.maxOrder - minOrder));
                    ArrayList<String> a = new ArrayList<String>();
                    int nb = this.moc.getNbRanges();
                    int i = (int)(Math.random() * (double)nb);
                    long npix = (this.moc.seeRangeList().begins(i) + (this.moc.seeRangeList().ends(i) - 1L)) / 2L;
                    int shift = (29 - order) * 2;
                    String key = order + "/" + (npix >>>= shift);
                    if (a.contains(key)) continue;
                    a.add(key);
                    if (allsky) {
                        key = "3/-1";
                        hk = new HealpixAllsky(this, 3, 0, 4);
                    } else {
                        hk = new HealpixKey(this, order, npix, 4);
                    }
                    long t = hk.timeNet;
                    long s = hk.sizeStream;
                    if (s == 0L) {
                        System.out.println(" error => " + this.url + "/" + hk.getFileNet());
                    } else {
                        System.out.println(".Loading " + key + " " + cds.tools.Util.getUnitDisk(s) + (hk.gzipped ? "/gzip" : "") + " in " + cds.tools.Util.getTemps(t * 1000L));
                    }
                    time += t;
                    if (allsky) {
                        allskyTime = t;
                    } else {
                        tileTime += t;
                    }
                    size += s;
                    ++n;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        Aladin.levelTrace = memo;
        System.out.println("=> Downloaded " + n + " tiles in " + HealpixKey.EXT[this.getTileMode()] + " : " + cds.tools.Util.getUnitDisk(size) + " in " + cds.tools.Util.getTemps(time * 1000L));
        long rate = (long)((double)size / ((double)time / 1000.0));
        String res = "=> Stream rate " + cds.tools.Util.getUnitDisk(rate) + "/s (" + n + " tiles)";
        System.out.println(res);
        this.aladin.console.printInfo(this.label + " net perf " + res);
        return cds.tools.Util.getUnitDisk(rate) + "/s (" + n + " tiles/avg=" + cds.tools.Util.getTemps(tileTime / (long)(n - 1) * 1000L) + " allsky/" + cds.tools.Util.getTemps(allskyTime * 1000L) + ")";
    }

    protected void incrGzipMode(int mode, long t) {
        if (this.inJPEG || this.inPNG) {
            return;
        }
        if (mode == 1) {
            ++this.nbgzip;
            this.timegzip += t;
        } else {
            ++this.nbnogzip;
            this.timenogzip += t;
        }
    }

    protected void resetGzippedMode() {
        this.nbnogzip = 0;
        this.nbgzip = 0;
        this.timenogzip = 0L;
        this.timegzip = 0L;
        this.gzipMode = 0;
    }

    protected int getGzippedMode() {
        if (this.inJPEG || this.inPNG) {
            return 2;
        }
        if (this.gzipMode > 0) {
            return this.gzipMode;
        }
        if (this.gzipMode == 0) {
            if (this.nbgzip < 2) {
                return -1;
            }
            if (this.nbnogzip < 2) {
                return -2;
            }
            if (this.nbgzip == 0) {
                return -1;
            }
            if (this.nbnogzip == 0) {
                return -2;
            }
            this.gzipMode = this.timegzip / (long)this.nbgzip < this.timenogzip / (long)this.nbnogzip ? 1 : 2;
        }
        return this.gzipMode;
    }

    public void center(Coord coord) {
        this.aladin.view.setRepere(coord);
        this.aladin.view.showSource();
        this.aladin.view.zoomview.repaint();
        this.aladin.calque.repaintAll();
    }

    protected void resetStats() {
        this.cumulTimeDraw = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimePixel = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimeStream = 0L;
        this.nbWriteCache = 0;
        this.nbLoadCache = 0;
        this.nbLoadNet = 0;
        this.nByteWriteCache = 0L;
        this.nByteReadCache = 0L;
        this.nByteReadNet = 0L;
        this.nbImgDraw = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.nbCreated = 0;
        this.nbImgInBuf = 0;
        this.nbImgCreated = 0;
        this.resetGzippedMode();
    }

    @Override
    protected String getStats() {
        return "HealpixKey stats: " + this.label + ":\n.Created: " + this.nbCreated + "   Abort: " + this.nbAborted + "   Free: " + this.nbFree + "\n.Net   : " + this.nbLoadNet + " => " + cds.tools.Util.round((double)this.nByteReadNet / 1048576.0, 2) + "Mb in ~" + cds.tools.Util.round(this.avgLoadNet(), 0) + "ms " + this.streamJpegPixel() + "\n.CacheR: " + this.nbLoadCache + " => " + cds.tools.Util.round((double)this.nByteReadCache / 1048576.0, 2) + "Mb in ~" + cds.tools.Util.round(this.avgLoadCache(), 0) + "ms\n.CacheW: " + this.nbWriteCache + " => " + cds.tools.Util.round((double)this.nByteWriteCache / 1048576.0, 2) + "Mb in ~" + cds.tools.Util.round(this.avgWriteCache(), 0) + "ms\n.Img created: " + this.nbImgCreated + "    reused:" + this.nbImgInBuf + "    drawn " + this.nbImgDraw + " in ~" + cds.tools.Util.round(this.avgDraw(), 0) + "ms\n";
    }

    public String getCreatorFromId() {
        String s = this.id;
        if (s == null) {
            return null;
        }
        if (s.startsWith("ivo://")) {
            s = s.substring(6);
        }
        int offset = s.indexOf(47);
        int offset1 = s.indexOf(63);
        if (offset == -1 && offset1 == -1) {
            return null;
        }
        if (offset == -1) {
            offset = s.length();
        }
        if (offset1 == -1) {
            offset1 = s.length();
        }
        if (offset1 < offset) {
            offset = offset1;
        }
        return s.substring(0, offset);
    }

    private String getHost() {
        int i = this.url.indexOf("//");
        if (i == -1) {
            return "?";
        }
        int j = this.url.indexOf("/", i + 2);
        if (j < 0) {
            j = this.url.length();
        }
        return this.url.substring(i + 2, j);
    }

    protected String getShortStats() {
        if (this.nbLoadNet == 0 && this.nbLoadCache == 0) {
            return null;
        }
        boolean flagLocal = this.isLocalAllSky();
        String name = this.id != null ? this.id : this.label;
        return name + (flagLocal ? " Local:" : " Net[" + this.getHost() + "]:") + this.nbLoadNet + "/" + cds.tools.Util.round((double)this.nByteReadNet / 1048576.0, 2) + "Mb/" + cds.tools.Util.round(this.avgLoadNet(), 0) + "ms CacheR:" + this.nbLoadCache + "/" + cds.tools.Util.round((double)this.nByteReadCache / 1048576.0, 2) + "Mb/" + cds.tools.Util.round(this.avgLoadCache(), 0) + "ms CacheW:" + this.nbWriteCache + "/" + cds.tools.Util.round((double)this.nByteWriteCache / 1048576.0, 2) + "Mb/" + cds.tools.Util.round(this.avgWriteCache(), 0) + "ms";
    }

    protected String streamJpegPixel() {
        if (this.nbLoadNet == 0) {
            return "";
        }
        return "(stream=" + cds.tools.Util.round(this.cumulTimeStream / (long)this.nbLoadNet, 1) + "/jpeg=" + cds.tools.Util.round(this.cumulTimeJPEG / (long)this.nbLoadNet, 1) + "/getpix=" + cds.tools.Util.round(this.cumulTimePixel / (long)this.nbLoadNet, 1) + ")";
    }

    protected String getNetSpeed() {
        long r = this.rateLoadNet();
        int er = this.nbTileError();
        if (er == 0 && r == 0L) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        if (r != 0L) {
            s.append(cds.tools.Util.getUnitDisk(r) + "/s");
        }
        if (er > 0) {
            if (s.length() > 0) {
                s.append(" - ");
            }
            s.append("tile errors: " + er + "/" + this.pixList.size() + " (" + cds.tools.Util.myRound(100.0 * (double)er / (double)this.pixList.size()) + "%)");
        }
        return s.toString();
    }

    protected int nbTileError() {
        if (this.moc == null) {
            return 0;
        }
        this.removeHealpixOutsideMoc();
        Enumeration<HealpixKey> e = this.pixList.elements();
        int n = 0;
        while (e.hasMoreElements()) {
            HealpixKey h = e.nextElement();
            if (h.getStatus() != 7) continue;
            ++n;
            Aladin.trace(4, "Error on " + h);
        }
        return n;
    }

    protected long rateLoadNet() {
        if (this.cumulTimeLoadNet == 0L) {
            return 0L;
        }
        long r = this.nByteReadNet / this.cumulTimeLoadNet * 1000L;
        return r;
    }

    protected double avgDraw() {
        if (this.nbImgDraw == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeDraw / (double)this.nbImgDraw / 1000000.0;
    }

    protected double avgLoadNet() {
        if (this.nbLoadNet == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeLoadNet / (double)this.nbLoadNet;
    }

    protected double avgLoadCache() {
        if (this.nbLoadCache == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeLoadCache / (double)this.nbLoadCache;
    }

    protected double avgWriteCache() {
        if (this.nbWriteCache == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeWriteCache / (double)this.nbWriteCache;
    }

    class HealpixLoader
    implements Runnable {
        static final int POOLSIZE = 1;
        boolean POOLTEST = true;
        static final int DELAI = 10000;
        private boolean loading = false;
        private boolean purging = false;
        private Thread thread = null;
        private Loader cacheLoader;
        private Loader netLoader;
        private Loader[] netPool;
        private volatile boolean sleep;
        private boolean isSleeping = false;
        private Object lockSleep = new Object();
        private long ot = -1L;

        HealpixLoader() {
            this.cacheLoader = new Loader(0);
            this.netPool = new Loader[1];
            for (int i = 0; i < this.netPool.length; ++i) {
                this.netPool[i] = new Loader(1);
            }
            this.netLoader = new Loader(1);
            this.wakeUp();
        }

        protected boolean isReadyForDrawing() {
            return PlanBG.this.readyAfterDraw;
        }

        protected boolean isLoading() {
            return this.loading;
        }

        protected boolean isPurging() {
            return this.purging;
        }

        protected void wakeUp() {
            if (this.thread != null) {
                this.loading = true;
                this.noSleep();
                if (this.isSleeping()) {
                    this.thread.interrupt();
                }
            } else {
                this.thread = new Thread((Runnable)this, "HealpixLoader");
                this.thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void noSleep() {
            Object object = this.lockSleep;
            synchronized (object) {
                this.sleep = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isSleeping() {
            Object object = this.lockSleep;
            synchronized (object) {
                return this.isSleeping;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSleep(boolean flag) {
            Object object = this.lockSleep;
            synchronized (object) {
                this.isSleeping = flag;
            }
        }

        private boolean shouldRun() {
            return this.isLoading() || this.isPurging();
        }

        @Override
        public void run() {
            cds.tools.Util.pause(100);
            if (PlanBG.this.useCache) {
                this.cacheLoader.start();
            }
            boolean bl = this.POOLTEST = !PlanBG.this.local && PlanBG.this.aladin.view.getNbView() <= 2;
            if (this.POOLTEST) {
                for (Loader a : this.netPool) {
                    a.start();
                }
            } else {
                this.netLoader.start();
            }
            do {
                this.sleep = true;
                try {
                    try {
                        this.launchJob();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (PlanBG.this.useCache) {
                        PlanBG.scanCache();
                    }
                    if (!this.sleep) continue;
                    this.setSleep(true);
                    Aladin.trace(5, "PlanBG.HealpixLoader sleeping");
                    try {
                        Thread.currentThread();
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                        Aladin.trace(5, "PlanBG.HealpixLoader wake up !");
                    }
                    this.setSleep(false);
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            } while (this.shouldRun());
            if (PlanBG.this.useCache) {
                this.cacheLoader.stop();
            }
            if (this.POOLTEST) {
                for (Loader a : this.netPool) {
                    a.stop();
                }
            } else {
                this.netLoader.stop();
            }
            this.thread = null;
            Aladin.trace(5, "PlanBG.HealpixLoader died");
            PlanBG.this.nbFlush = 0;
            PlanBG.this.aladin.gcIfRequired();
        }

        private void launchJob() throws Exception {
            boolean stillOnePurge = false;
            boolean perhapsOneDeath = false;
            int[] nb = new int[HealpixKey.NBSTATUS];
            Aladin cfr_ignored_0 = PlanBG.this.aladin;
            boolean flagVerbose = Aladin.levelTrace >= 5;
            boolean first = true;
            int n = 0;
            try {
                ArrayList<HealpixKey> list = new ArrayList<HealpixKey>();
                Enumeration<HealpixKey> e = PlanBG.this.pixList.elements();
                while (e.hasMoreElements()) {
                    list.add(e.nextElement());
                }
                try {
                    Collections.sort(list);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (HealpixKey healpix : list) {
                    int live;
                    int status = healpix.getStatus();
                    if (flagVerbose && status != 7) {
                        System.out.println((first ? "\n" : "") + healpix);
                        first = false;
                    }
                    if ((live = healpix.getLive()) == -1) {
                        PlanBG.this.purge(healpix);
                    } else if (live == -2) {
                        perhapsOneDeath = true;
                        stillOnePurge = true;
                    } else if (status == 6) {
                        healpix.purgeFils();
                    }
                    switch (status) {
                        case 1: {
                            if (!healpix.allSky && healpix.priority >= 1000) {
                                healpix.setOld();
                                break;
                            }
                            if (PlanBG.this.useCache && healpix.isCached()) {
                                status = 2;
                                healpix.setStatus(2);
                                break;
                            }
                            status = 3;
                            healpix.setStatus(3);
                            break;
                        }
                        case 6: {
                            if (!PlanBG.this.useCache) break;
                            healpix.write();
                        }
                    }
                    int n2 = status;
                    nb[n2] = nb[n2] + 1;
                    if (healpix.priority < 250 && status != 6 && status != 7) {
                        ++n;
                        continue;
                    }
                    if (healpix.npix != -1L || status == 6 || status == 7) continue;
                    n += 10;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.loading = nb[1] > 0 || nb[2] > 0 || nb[3] > 0 || nb[4] > 0 || nb[5] > 0;
            boolean bl = this.purging = stillOnePurge || nb[9] > 0;
            PlanBG.this.pourcent = n == 0 ? -2.0 : (n >= 10 ? 1.0 : (double)(10 - n) * 10.0);
            PlanBG.this.readyAfterDraw = n == 0;
            PlanBG.this.nbReady = nb[6];
            if (PlanBG.this.detectServerError(nb)) {
                PlanBG.this.error = "Server not available";
            }
            HealpixKey healpixMin = null;
            HealpixKey healpixNet = null;
            int min = Integer.MAX_VALUE;
            Enumeration<HealpixKey> e = PlanBG.this.pixList.elements();
            while (e.hasMoreElements()) {
                HealpixKey healpix = e.nextElement();
                int status = healpix.getStatus();
                if (status != 3 && status != 5) continue;
                if (status == 5) {
                    healpixNet = healpix;
                }
                if (healpix.priority >= min) continue;
                min = healpix.priority;
                healpixMin = healpix;
            }
            if (healpixNet != null && healpixNet != healpixMin) {
                healpixNet.abort();
            }
            if (nb[2] > 0) {
                this.cacheLoader.wakeUp();
            }
            if (nb[3] > 0) {
                if (this.POOLTEST) {
                    for (Loader a : this.netPool) {
                        if (!a.isPause()) continue;
                        a.wakeUp();
                    }
                } else {
                    this.netLoader.wakeUp();
                }
            }
            if (PlanBG.this.aladin.calque != null && PlanBG.this.oLoading != this.loading) {
                PlanBG.this.oLoading = this.loading;
                PlanBG.this.aladin.calque.select.repaint();
            }
            if (perhapsOneDeath) {
                PlanBG.this.shouldRefresh();
            }
        }
    }

    static class FileItem {
        File f;
        long date;

        FileItem(File f) {
            this.f = f;
            this.date = f.lastModified();
        }

        boolean hasBeenModified() {
            return this.date != this.f.lastModified();
        }
    }

    class Loader
    implements Runnable {
        boolean encore;
        Thread thread;
        int type;
        String label;
        private boolean pause = false;

        Loader(int type) {
            this.type = type;
            this.label = (type == 0 ? "LoaderCache-" : "LoaderNet-") + THREADID++;
        }

        void start() {
            this.encore = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = new Thread((Runnable)this, this.label);
            if (!Aladin.NOGUI) {
                cds.tools.Util.decreasePriority(Thread.currentThread(), this.thread);
            }
            this.thread.start();
        }

        void wakeUp() {
            if (this.thread == null) {
                this.start();
            } else if (this.pause) {
                this.thread.interrupt();
            }
        }

        synchronized void setPause(boolean flag) {
            this.pause = flag;
        }

        boolean isPause() {
            return this.pause;
        }

        void stop() {
            this.encore = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        @Override
        public void run() {
            while (this.encore) {
                try {
                    boolean flagLoad;
                    block17: {
                        flagLoad = false;
                        if (!PlanBG.this.aladin.view.mustDrawFast()) {
                            try {
                                ArrayList<HealpixKey> list = new ArrayList<HealpixKey>();
                                MyEnum e = new MyEnum(PlanBG.this.pixList);
                                while (e.hasMoreElements()) {
                                    HealpixKey healpix = (HealpixKey)e.nextElement();
                                    int status = healpix.getStatus();
                                    if (this.type == 0 && status == 2) {
                                        healpix.loadFromCache();
                                        if (!healpix.allSky) {
                                            PlanBG.this.setTileOrder(healpix.getLosangeOrder());
                                        }
                                        flagLoad = true;
                                        continue;
                                    }
                                    if (this.type != 1 || status != 3) continue;
                                    list.add(healpix);
                                }
                                long t = System.currentTimeMillis();
                                if (list.size() > 0) {
                                    Collections.sort(list);
                                    for (HealpixKey h : list) {
                                        h.waitLock();
                                        if (h.getStatus() != 3) {
                                            h.unLock();
                                            continue;
                                        }
                                        if (this.type == 0) {
                                            h.loadFromCache();
                                        } else {
                                            h.loadFromNet();
                                        }
                                        h.unLock();
                                        if (h.allSky) continue;
                                        PlanBG.this.setTileOrder(h.getLosangeOrder());
                                    }
                                    flagLoad = true;
                                }
                            }
                            catch (Exception e) {
                                if (Aladin.levelTrace < 3) break block17;
                                e.printStackTrace();
                            }
                        }
                    }
                    if (flagLoad) {
                        PlanBG.this.loader.wakeUp();
                        continue;
                    }
                    try {
                        this.setPause(true);
                        Thread.currentThread();
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                    }
                }
                catch (Throwable t) {
                    if (Aladin.levelTrace < 3) continue;
                    t.printStackTrace();
                }
            }
            Aladin.trace(5, "PlanBG.Loader (" + this.label + ") died !");
            this.thread = null;
        }
    }

    class MyEnum
    implements Enumeration<HealpixKey> {
        HealpixKey[] tab;
        int size;
        int pos;

        MyEnum(Hashtable<String, HealpixKey> pixList) {
            int i;
            this.tab = new HealpixKey[pixList.size()];
            Enumeration<HealpixKey> e = pixList.elements();
            for (i = 0; e.hasMoreElements() && i < this.tab.length; ++i) {
                this.tab[i] = e.nextElement();
            }
            this.size = i;
            try {
                Arrays.sort(this.tab, 0, this.size);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pos = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.pos < this.size;
        }

        @Override
        public HealpixKey nextElement() {
            return this.tab[this.pos++];
        }
    }
}

